package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.MonitoringObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.PccIdReqObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object.Monitoring;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcc.id.req.object.PccIdReq;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.monitoring.request.PceIdList;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link MonitoringRequestBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     MonitoringRequestBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new MonitoringRequestBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of MonitoringRequestBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see MonitoringRequestBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class MonitoringRequestBuilder implements Builder<MonitoringRequest> {

    private Monitoring _monitoring;
    private PccIdReq _pccIdReq;
    private List<PceIdList> _pceIdList;


    Map<Class<? extends Augmentation<MonitoringRequest>>, Augmentation<MonitoringRequest>> augmentation = Collections.emptyMap();

    public MonitoringRequestBuilder() {
    }
    
    
    
    public MonitoringRequestBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Monitoring arg) {
        this._monitoring = arg.getMonitoring();
        this._pccIdReq = arg.getPccIdReq();
    }
    public MonitoringRequestBuilder(MonitoringObject arg) {
        this._monitoring = arg.getMonitoring();
    }
    public MonitoringRequestBuilder(PccIdReqObject arg) {
        this._pccIdReq = arg.getPccIdReq();
    }

    public MonitoringRequestBuilder(MonitoringRequest base) {
        Map<Class<? extends Augmentation<MonitoringRequest>>, Augmentation<MonitoringRequest>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._monitoring = base.getMonitoring();
        this._pccIdReq = base.getPccIdReq();
        this._pceIdList = base.getPceIdList();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>PccIdReqObject</li>
     * <li>MonitoringObject</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Monitoring</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PccIdReqObject) {
            this._pccIdReq = ((PccIdReqObject)arg).getPccIdReq();
            isValidArg = true;
        }
        if (arg instanceof MonitoringObject) {
            this._monitoring = ((MonitoringObject)arg).getMonitoring();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Monitoring) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[PccIdReqObject, MonitoringObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Monitoring]");
    }

    public Monitoring getMonitoring() {
        return _monitoring;
    }
    
    public PccIdReq getPccIdReq() {
        return _pccIdReq;
    }
    
    public List<PceIdList> getPceIdList() {
        return _pceIdList;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<MonitoringRequest>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public MonitoringRequestBuilder setMonitoring(final Monitoring value) {
        this._monitoring = value;
        return this;
    }
    
    public MonitoringRequestBuilder setPccIdReq(final PccIdReq value) {
        this._pccIdReq = value;
        return this;
    }
    public MonitoringRequestBuilder setPceIdList(final List<PceIdList> values) {
        this._pceIdList = values;
        return this;
    }
    
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public MonitoringRequestBuilder addAugmentation(Augmentation<MonitoringRequest> augmentation) {
        Class<? extends Augmentation<MonitoringRequest>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public MonitoringRequestBuilder removeAugmentation(Class<? extends Augmentation<MonitoringRequest>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public MonitoringRequest build() {
        return new MonitoringRequestImpl(this);
    }

    private static final class MonitoringRequestImpl
        extends AbstractAugmentable<MonitoringRequest>
        implements MonitoringRequest {
    
        private final Monitoring _monitoring;
        private final PccIdReq _pccIdReq;
        private final List<PceIdList> _pceIdList;
    
        MonitoringRequestImpl(MonitoringRequestBuilder base) {
            super(base.augmentation);
            this._monitoring = base.getMonitoring();
            this._pccIdReq = base.getPccIdReq();
            this._pceIdList = CodeHelpers.emptyToNull(base.getPceIdList());
        }
    
        @Override
        public Monitoring getMonitoring() {
            return _monitoring;
        }
        
        @Override
        public PccIdReq getPccIdReq() {
            return _pccIdReq;
        }
        
        @Override
        public List<PceIdList> getPceIdList() {
            return _pceIdList;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = MonitoringRequest.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return MonitoringRequest.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return MonitoringRequest.bindingToString(this);
        }
    }
}
