package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.RpObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.VendorInformationObjects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.PcreqMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.PathKeyExpansion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.SegmentComputation;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * list requests {
 *   uses rp-object;
 *   container path-key-expansion {
 *     when "rp/path-key = true";
 *     uses path-key-object;
 *   }
 *   container segment-computation {
 *     when "rp/path-key = false";
 *     container p2p {
 *       when "../rp/p2mp = false";
 *       uses endpoints-object;
 *       container reported-route {
 *         uses reported-route-object;
 *         uses reoptimization-bandwidth-object;
 *       }
 *       uses vendor-information-objects;
 *       uses load-balancing-object;
 *       uses lsp-attributes;
 *     }
 *     container p2mp {
 *       when "../rp/p2mp = true";
 *       list endpoint-rro-pair {
 *         uses endpoints-object;
 *         list rros {
 *           choice route-object {
 *             case reported-route-object-case {
 *               uses reported-route-object;
 *             }
 *             case secondary-reported-route-object-case {
 *               uses secondary-reported-route-object;
 *             }
 *           }
 *         }
 *         uses reoptimization-bandwidth-object;
 *         min-elements 1;
 *       }
 *       uses of-object;
 *       uses lspa-object;
 *       uses bandwidth-object;
 *       list metric {
 *         uses metric-object;
 *       }
 *       choice iro-bnc-choice {
 *         case iro-case {
 *           uses include-route-object;
 *         }
 *         case bnc-case {
 *           uses bnc-object;
 *         }
 *       }
 *       uses load-balancing-object;
 *     }
 *   }
 *   uses vendor-information-objects;
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typespcreq-messagepcreq-messagerequests</i>
 *
 * <p>To create instances of this class use {@link RequestsBuilder}.
 * @see RequestsBuilder
 *
 *
 */
@Generated("mdsal-binding-generator")
public interface Requests
    extends
    ChildOf<PcreqMessage>,
    Augmentable<Requests>,
    RpObject,
    VendorInformationObjects
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("requests");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.Requests> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.Requests.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.@NonNull Requests obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getPathKeyExpansion());
        result = prime * result + Objects.hashCode(obj.getRp());
        result = prime * result + Objects.hashCode(obj.getSegmentComputation());
        result = prime * result + Objects.hashCode(obj.getVendorInformationObject());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.@NonNull Requests thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.Requests other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.Requests.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getPathKeyExpansion(), other.getPathKeyExpansion())) {
            return false;
        }
        if (!Objects.equals(thisObj.getRp(), other.getRp())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSegmentComputation(), other.getSegmentComputation())) {
            return false;
        }
        if (!Objects.equals(thisObj.getVendorInformationObject(), other.getVendorInformationObject())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.@NonNull Requests obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Requests");
        CodeHelpers.appendValue(helper, "pathKeyExpansion", obj.getPathKeyExpansion());
        CodeHelpers.appendValue(helper, "rp", obj.getRp());
        CodeHelpers.appendValue(helper, "segmentComputation", obj.getSegmentComputation());
        CodeHelpers.appendValue(helper, "vendorInformationObject", obj.getVendorInformationObject());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return pathKeyExpansion, or {@code null} if it is not present.
     *
     * @return {@code PathKeyExpansion} pathKeyExpansion, or {@code null} if it is not present.
     *
     */
    PathKeyExpansion getPathKeyExpansion();
    
    /**
     * Return segmentComputation, or {@code null} if it is not present.
     *
     * @return {@code SegmentComputation} segmentComputation, or {@code null} if it is not present.
     *
     */
    SegmentComputation getSegmentComputation();

}

