package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.RpObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.VendorInformationObjects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.PathKeyExpansion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.SegmentComputation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.Rp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.objects.VendorInformationObject;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link RequestsBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     RequestsBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new RequestsBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of RequestsBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see RequestsBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class RequestsBuilder implements Builder<Requests> {

    private PathKeyExpansion _pathKeyExpansion;
    private Rp _rp;
    private SegmentComputation _segmentComputation;
    private List<VendorInformationObject> _vendorInformationObject;


    Map<Class<? extends Augmentation<Requests>>, Augmentation<Requests>> augmentation = Collections.emptyMap();

    public RequestsBuilder() {
    }
    
    
    
    public RequestsBuilder(RpObject arg) {
        this._rp = arg.getRp();
    }
    
    public RequestsBuilder(VendorInformationObjects arg) {
        this._vendorInformationObject = arg.getVendorInformationObject();
    }

    public RequestsBuilder(Requests base) {
        Map<Class<? extends Augmentation<Requests>>, Augmentation<Requests>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._pathKeyExpansion = base.getPathKeyExpansion();
        this._rp = base.getRp();
        this._segmentComputation = base.getSegmentComputation();
        this._vendorInformationObject = base.getVendorInformationObject();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>RpObject</li>
     * <li>VendorInformationObjects</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof RpObject) {
            this._rp = ((RpObject)arg).getRp();
            isValidArg = true;
        }
        if (arg instanceof VendorInformationObjects) {
            this._vendorInformationObject = ((VendorInformationObjects)arg).getVendorInformationObject();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[RpObject, VendorInformationObjects]");
    }

    public PathKeyExpansion getPathKeyExpansion() {
        return _pathKeyExpansion;
    }
    
    public Rp getRp() {
        return _rp;
    }
    
    public SegmentComputation getSegmentComputation() {
        return _segmentComputation;
    }
    
    public List<VendorInformationObject> getVendorInformationObject() {
        return _vendorInformationObject;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Requests>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public RequestsBuilder setPathKeyExpansion(final PathKeyExpansion value) {
        this._pathKeyExpansion = value;
        return this;
    }
    
    public RequestsBuilder setRp(final Rp value) {
        this._rp = value;
        return this;
    }
    
    public RequestsBuilder setSegmentComputation(final SegmentComputation value) {
        this._segmentComputation = value;
        return this;
    }
    public RequestsBuilder setVendorInformationObject(final List<VendorInformationObject> values) {
        this._vendorInformationObject = values;
        return this;
    }
    
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public RequestsBuilder addAugmentation(Augmentation<Requests> augmentation) {
        Class<? extends Augmentation<Requests>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public RequestsBuilder removeAugmentation(Class<? extends Augmentation<Requests>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Requests build() {
        return new RequestsImpl(this);
    }

    private static final class RequestsImpl
        extends AbstractAugmentable<Requests>
        implements Requests {
    
        private final PathKeyExpansion _pathKeyExpansion;
        private final Rp _rp;
        private final SegmentComputation _segmentComputation;
        private final List<VendorInformationObject> _vendorInformationObject;
    
        RequestsImpl(RequestsBuilder base) {
            super(base.augmentation);
            this._pathKeyExpansion = base.getPathKeyExpansion();
            this._rp = base.getRp();
            this._segmentComputation = base.getSegmentComputation();
            this._vendorInformationObject = CodeHelpers.emptyToNull(base.getVendorInformationObject());
        }
    
        @Override
        public PathKeyExpansion getPathKeyExpansion() {
            return _pathKeyExpansion;
        }
        
        @Override
        public Rp getRp() {
            return _rp;
        }
        
        @Override
        public SegmentComputation getSegmentComputation() {
            return _segmentComputation;
        }
        
        @Override
        public List<VendorInformationObject> getVendorInformationObject() {
            return _vendorInformationObject;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Requests.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Requests.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Requests.bindingToString(this);
        }
    }
}
