package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ExcludeRouteObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.GcObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.OfObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.SvecObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.VendorInformationObjects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.PcreqMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.svec.Metric;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * list svec {
 *   uses svec-object;
 *   uses of-object;
 *   uses gc-object;
 *   uses exclude-route-object;
 *   list metric {
 *     uses metric-object;
 *   }
 *   uses vendor-information-objects;
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typespcreq-messagepcreq-messagesvec</i>
 *
 * <p>To create instances of this class use {@link SvecBuilder}.
 * @see SvecBuilder
 *
 *
 */
@Generated("mdsal-binding-generator")
public interface Svec
    extends
    ChildOf<PcreqMessage>,
    Augmentable<Svec>,
    SvecObject,
    OfObject,
    GcObject,
    ExcludeRouteObject,
    VendorInformationObjects
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("svec");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.Svec> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.Svec.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.@NonNull Svec obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getGc());
        result = prime * result + Objects.hashCode(obj.getMetric());
        result = prime * result + Objects.hashCode(obj.getOf());
        result = prime * result + Objects.hashCode(obj.getSvec());
        result = prime * result + Objects.hashCode(obj.getVendorInformationObject());
        result = prime * result + Objects.hashCode(obj.getXro());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.@NonNull Svec thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.Svec other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.Svec.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getGc(), other.getGc())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMetric(), other.getMetric())) {
            return false;
        }
        if (!Objects.equals(thisObj.getOf(), other.getOf())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSvec(), other.getSvec())) {
            return false;
        }
        if (!Objects.equals(thisObj.getVendorInformationObject(), other.getVendorInformationObject())) {
            return false;
        }
        if (!Objects.equals(thisObj.getXro(), other.getXro())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.@NonNull Svec obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Svec");
        CodeHelpers.appendValue(helper, "gc", obj.getGc());
        CodeHelpers.appendValue(helper, "metric", obj.getMetric());
        CodeHelpers.appendValue(helper, "of", obj.getOf());
        CodeHelpers.appendValue(helper, "svec", obj.getSvec());
        CodeHelpers.appendValue(helper, "vendorInformationObject", obj.getVendorInformationObject());
        CodeHelpers.appendValue(helper, "xro", obj.getXro());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return metric, or {@code null} if it is not present.
     *
     * @return {@code List<Metric>} metric, or {@code null} if it is not present.
     *
     */
    @Nullable List<Metric> getMetric();
    
    /**
     * Return metric, or an empty list if it is not present.
     *
     * @return {@code List<Metric>} metric, or an empty list if it is not present.
     *
     */
    default @NonNull List<Metric> nonnullMetric() {
        return CodeHelpers.nonnull(getMetric());
    }

}

