package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ExcludeRouteObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.GcObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.OfObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.SvecObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.VendorInformationObjects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.Xro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.gc.object.Gc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.object.Of;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.svec.Metric;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.objects.VendorInformationObject;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SvecBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     SvecBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new SvecBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of SvecBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see SvecBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class SvecBuilder implements Builder<Svec> {

    private Gc _gc;
    private List<Metric> _metric;
    private Of _of;
    private org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.svec.object.Svec _svec;
    private List<VendorInformationObject> _vendorInformationObject;
    private Xro _xro;


    Map<Class<? extends Augmentation<Svec>>, Augmentation<Svec>> augmentation = Collections.emptyMap();

    public SvecBuilder() {
    }
    
    
    
    public SvecBuilder(SvecObject arg) {
        this._svec = arg.getSvec();
    }
    
    public SvecBuilder(OfObject arg) {
        this._of = arg.getOf();
    }
    
    public SvecBuilder(GcObject arg) {
        this._gc = arg.getGc();
    }
    
    public SvecBuilder(ExcludeRouteObject arg) {
        this._xro = arg.getXro();
    }
    
    public SvecBuilder(VendorInformationObjects arg) {
        this._vendorInformationObject = arg.getVendorInformationObject();
    }

    public SvecBuilder(Svec base) {
        Map<Class<? extends Augmentation<Svec>>, Augmentation<Svec>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._gc = base.getGc();
        this._metric = base.getMetric();
        this._of = base.getOf();
        this._svec = base.getSvec();
        this._vendorInformationObject = base.getVendorInformationObject();
        this._xro = base.getXro();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>SvecObject</li>
     * <li>OfObject</li>
     * <li>ExcludeRouteObject</li>
     * <li>GcObject</li>
     * <li>VendorInformationObjects</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SvecObject) {
            this._svec = ((SvecObject)arg).getSvec();
            isValidArg = true;
        }
        if (arg instanceof OfObject) {
            this._of = ((OfObject)arg).getOf();
            isValidArg = true;
        }
        if (arg instanceof ExcludeRouteObject) {
            this._xro = ((ExcludeRouteObject)arg).getXro();
            isValidArg = true;
        }
        if (arg instanceof GcObject) {
            this._gc = ((GcObject)arg).getGc();
            isValidArg = true;
        }
        if (arg instanceof VendorInformationObjects) {
            this._vendorInformationObject = ((VendorInformationObjects)arg).getVendorInformationObject();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[SvecObject, OfObject, ExcludeRouteObject, GcObject, VendorInformationObjects]");
    }

    public Gc getGc() {
        return _gc;
    }
    
    public List<Metric> getMetric() {
        return _metric;
    }
    
    public Of getOf() {
        return _of;
    }
    
    public org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.svec.object.Svec getSvec() {
        return _svec;
    }
    
    public List<VendorInformationObject> getVendorInformationObject() {
        return _vendorInformationObject;
    }
    
    public Xro getXro() {
        return _xro;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Svec>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public SvecBuilder setGc(final Gc value) {
        this._gc = value;
        return this;
    }
    public SvecBuilder setMetric(final List<Metric> values) {
        this._metric = values;
        return this;
    }
    
    
    public SvecBuilder setOf(final Of value) {
        this._of = value;
        return this;
    }
    
    public SvecBuilder setSvec(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.svec.object.Svec value) {
        this._svec = value;
        return this;
    }
    public SvecBuilder setVendorInformationObject(final List<VendorInformationObject> values) {
        this._vendorInformationObject = values;
        return this;
    }
    
    
    public SvecBuilder setXro(final Xro value) {
        this._xro = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public SvecBuilder addAugmentation(Augmentation<Svec> augmentation) {
        Class<? extends Augmentation<Svec>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public SvecBuilder removeAugmentation(Class<? extends Augmentation<Svec>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Svec build() {
        return new SvecImpl(this);
    }

    private static final class SvecImpl
        extends AbstractAugmentable<Svec>
        implements Svec {
    
        private final Gc _gc;
        private final List<Metric> _metric;
        private final Of _of;
        private final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.svec.object.Svec _svec;
        private final List<VendorInformationObject> _vendorInformationObject;
        private final Xro _xro;
    
        SvecImpl(SvecBuilder base) {
            super(base.augmentation);
            this._gc = base.getGc();
            this._metric = CodeHelpers.emptyToNull(base.getMetric());
            this._of = base.getOf();
            this._svec = base.getSvec();
            this._vendorInformationObject = CodeHelpers.emptyToNull(base.getVendorInformationObject());
            this._xro = base.getXro();
        }
    
        @Override
        public Gc getGc() {
            return _gc;
        }
        
        @Override
        public List<Metric> getMetric() {
            return _metric;
        }
        
        @Override
        public Of getOf() {
            return _of;
        }
        
        @Override
        public org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.svec.object.Svec getSvec() {
            return _svec;
        }
        
        @Override
        public List<VendorInformationObject> getVendorInformationObject() {
            return _vendorInformationObject;
        }
        
        @Override
        public Xro getXro() {
            return _xro;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Svec.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Svec.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Svec.bindingToString(this);
        }
    }
}
