package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.Requests;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.P2mp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.P2p;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container segment-computation {
 *   when "rp/path-key = false";
 *   container p2p {
 *     when "../rp/p2mp = false";
 *     uses endpoints-object;
 *     container reported-route {
 *       uses reported-route-object;
 *       uses reoptimization-bandwidth-object;
 *     }
 *     uses vendor-information-objects;
 *     uses load-balancing-object;
 *     uses lsp-attributes;
 *   }
 *   container p2mp {
 *     when "../rp/p2mp = true";
 *     list endpoint-rro-pair {
 *       uses endpoints-object;
 *       list rros {
 *         choice route-object {
 *           case reported-route-object-case {
 *             uses reported-route-object;
 *           }
 *           case secondary-reported-route-object-case {
 *             uses secondary-reported-route-object;
 *           }
 *         }
 *       }
 *       uses reoptimization-bandwidth-object;
 *       min-elements 1;
 *     }
 *     uses of-object;
 *     uses lspa-object;
 *     uses bandwidth-object;
 *     list metric {
 *       uses metric-object;
 *     }
 *     choice iro-bnc-choice {
 *       case iro-case {
 *         uses include-route-object;
 *       }
 *       case bnc-case {
 *         uses bnc-object;
 *       }
 *     }
 *     uses load-balancing-object;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typespcreq-messagepcreq-messagerequestssegment-computation</i>
 *
 * <p>To create instances of this class use {@link SegmentComputationBuilder}.
 * @see SegmentComputationBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface SegmentComputation
    extends
    ChildOf<Requests>,
    Augmentable<SegmentComputation>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("segment-computation");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.SegmentComputation> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.SegmentComputation.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.@NonNull SegmentComputation obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getP2mp());
        result = prime * result + Objects.hashCode(obj.getP2p());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.@NonNull SegmentComputation thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.SegmentComputation other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.SegmentComputation.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getP2mp(), other.getP2mp())) {
            return false;
        }
        if (!Objects.equals(thisObj.getP2p(), other.getP2p())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.@NonNull SegmentComputation obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SegmentComputation");
        CodeHelpers.appendValue(helper, "p2mp", obj.getP2mp());
        CodeHelpers.appendValue(helper, "p2p", obj.getP2p());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return p2p, or {@code null} if it is not present.
     *
     * @return {@code P2p} p2p, or {@code null} if it is not present.
     *
     */
    P2p getP2p();
    
    /**
     * Return p2mp, or {@code null} if it is not present.
     *
     * @return {@code P2mp} p2mp, or {@code null} if it is not present.
     *
     */
    P2mp getP2mp();

}

