package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.P2mp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.P2p;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link SegmentComputationBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     SegmentComputationBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new SegmentComputationBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of SegmentComputationBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see SegmentComputationBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class SegmentComputationBuilder implements Builder<SegmentComputation> {

    private P2mp _p2mp;
    private P2p _p2p;


    Map<Class<? extends Augmentation<SegmentComputation>>, Augmentation<SegmentComputation>> augmentation = Collections.emptyMap();

    public SegmentComputationBuilder() {
    }
    
    

    public SegmentComputationBuilder(SegmentComputation base) {
        Map<Class<? extends Augmentation<SegmentComputation>>, Augmentation<SegmentComputation>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._p2mp = base.getP2mp();
        this._p2p = base.getP2p();
    }


    public P2mp getP2mp() {
        return _p2mp;
    }
    
    public P2p getP2p() {
        return _p2p;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SegmentComputation>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public SegmentComputationBuilder setP2mp(final P2mp value) {
        this._p2mp = value;
        return this;
    }
    
    public SegmentComputationBuilder setP2p(final P2p value) {
        this._p2p = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public SegmentComputationBuilder addAugmentation(Augmentation<SegmentComputation> augmentation) {
        Class<? extends Augmentation<SegmentComputation>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public SegmentComputationBuilder removeAugmentation(Class<? extends Augmentation<SegmentComputation>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SegmentComputation build() {
        return new SegmentComputationImpl(this);
    }

    private static final class SegmentComputationImpl
        extends AbstractAugmentable<SegmentComputation>
        implements SegmentComputation {
    
        private final P2mp _p2mp;
        private final P2p _p2p;
    
        SegmentComputationImpl(SegmentComputationBuilder base) {
            super(base.augmentation);
            this._p2mp = base.getP2mp();
            this._p2p = base.getP2p();
        }
    
        @Override
        public P2mp getP2mp() {
            return _p2mp;
        }
        
        @Override
        public P2p getP2p() {
            return _p2p;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = SegmentComputation.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return SegmentComputation.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return SegmentComputation.bindingToString(this);
        }
    }
}
