package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.BandwidthObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.LoadBalancingObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.LspaObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.OfObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.SegmentComputation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.EndpointRroPair;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.IroBncChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.Metric;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container p2mp {
 *   when "../rp/p2mp = true";
 *   list endpoint-rro-pair {
 *     uses endpoints-object;
 *     list rros {
 *       choice route-object {
 *         case reported-route-object-case {
 *           uses reported-route-object;
 *         }
 *         case secondary-reported-route-object-case {
 *           uses secondary-reported-route-object;
 *         }
 *       }
 *     }
 *     uses reoptimization-bandwidth-object;
 *     min-elements 1;
 *   }
 *   uses of-object;
 *   uses lspa-object;
 *   uses bandwidth-object;
 *   list metric {
 *     uses metric-object;
 *   }
 *   choice iro-bnc-choice {
 *     case iro-case {
 *       uses include-route-object;
 *     }
 *     case bnc-case {
 *       uses bnc-object;
 *     }
 *   }
 *   uses load-balancing-object;
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typespcreq-messagepcreq-messagerequestssegment-computationp2mp</i>
 *
 * <p>To create instances of this class use {@link P2mpBuilder}.
 * @see P2mpBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface P2mp
    extends
    ChildOf<SegmentComputation>,
    Augmentable<P2mp>,
    OfObject,
    LspaObject,
    BandwidthObject,
    LoadBalancingObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("p2mp");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.P2mp> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.P2mp.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.@NonNull P2mp obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getBandwidth());
        result = prime * result + Objects.hashCode(obj.getEndpointRroPair());
        result = prime * result + Objects.hashCode(obj.getIroBncChoice());
        result = prime * result + Objects.hashCode(obj.getLoadBalancing());
        result = prime * result + Objects.hashCode(obj.getLspa());
        result = prime * result + Objects.hashCode(obj.getMetric());
        result = prime * result + Objects.hashCode(obj.getOf());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.@NonNull P2mp thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.P2mp other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.P2mp.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getBandwidth(), other.getBandwidth())) {
            return false;
        }
        if (!Objects.equals(thisObj.getEndpointRroPair(), other.getEndpointRroPair())) {
            return false;
        }
        if (!Objects.equals(thisObj.getIroBncChoice(), other.getIroBncChoice())) {
            return false;
        }
        if (!Objects.equals(thisObj.getLoadBalancing(), other.getLoadBalancing())) {
            return false;
        }
        if (!Objects.equals(thisObj.getLspa(), other.getLspa())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMetric(), other.getMetric())) {
            return false;
        }
        if (!Objects.equals(thisObj.getOf(), other.getOf())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.@NonNull P2mp obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("P2mp");
        CodeHelpers.appendValue(helper, "bandwidth", obj.getBandwidth());
        CodeHelpers.appendValue(helper, "endpointRroPair", obj.getEndpointRroPair());
        CodeHelpers.appendValue(helper, "iroBncChoice", obj.getIroBncChoice());
        CodeHelpers.appendValue(helper, "loadBalancing", obj.getLoadBalancing());
        CodeHelpers.appendValue(helper, "lspa", obj.getLspa());
        CodeHelpers.appendValue(helper, "metric", obj.getMetric());
        CodeHelpers.appendValue(helper, "of", obj.getOf());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return endpointRroPair, or {@code null} if it is not present.
     *
     * @return {@code List<EndpointRroPair>} endpointRroPair, or {@code null} if it is not present.
     *
     */
    @Nullable List<EndpointRroPair> getEndpointRroPair();
    
    /**
     * Return endpointRroPair, or an empty list if it is not present.
     *
     * @return {@code List<EndpointRroPair>} endpointRroPair, or an empty list if it is not present.
     *
     */
    default @NonNull List<EndpointRroPair> nonnullEndpointRroPair() {
        return CodeHelpers.nonnull(getEndpointRroPair());
    }
    
    /**
     * Return metric, or {@code null} if it is not present.
     *
     * @return {@code List<Metric>} metric, or {@code null} if it is not present.
     *
     */
    @Nullable List<Metric> getMetric();
    
    /**
     * Return metric, or an empty list if it is not present.
     *
     * @return {@code List<Metric>} metric, or an empty list if it is not present.
     *
     */
    default @NonNull List<Metric> nonnullMetric() {
        return CodeHelpers.nonnull(getMetric());
    }
    
    /**
     * Return iroBncChoice, or {@code null} if it is not present.
     *
     * @return {@code IroBncChoice} iroBncChoice, or {@code null} if it is not present.
     *
     */
    IroBncChoice getIroBncChoice();

}

