package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.BandwidthObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.LoadBalancingObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.LspaObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.OfObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bandwidth.object.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.load.balancing.object.LoadBalancing;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.Lspa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.object.Of;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.EndpointRroPair;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.IroBncChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.Metric;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link P2mpBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     P2mpBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new P2mpBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of P2mpBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see P2mpBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class P2mpBuilder implements Builder<P2mp> {

    private Bandwidth _bandwidth;
    private List<EndpointRroPair> _endpointRroPair;
    private IroBncChoice _iroBncChoice;
    private LoadBalancing _loadBalancing;
    private Lspa _lspa;
    private List<Metric> _metric;
    private Of _of;


    Map<Class<? extends Augmentation<P2mp>>, Augmentation<P2mp>> augmentation = Collections.emptyMap();

    public P2mpBuilder() {
    }
    
    
    
    public P2mpBuilder(OfObject arg) {
        this._of = arg.getOf();
    }
    
    public P2mpBuilder(LspaObject arg) {
        this._lspa = arg.getLspa();
    }
    
    public P2mpBuilder(BandwidthObject arg) {
        this._bandwidth = arg.getBandwidth();
    }
    
    public P2mpBuilder(LoadBalancingObject arg) {
        this._loadBalancing = arg.getLoadBalancing();
    }

    public P2mpBuilder(P2mp base) {
        Map<Class<? extends Augmentation<P2mp>>, Augmentation<P2mp>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._bandwidth = base.getBandwidth();
        this._endpointRroPair = base.getEndpointRroPair();
        this._iroBncChoice = base.getIroBncChoice();
        this._loadBalancing = base.getLoadBalancing();
        this._lspa = base.getLspa();
        this._metric = base.getMetric();
        this._of = base.getOf();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>BandwidthObject</li>
     * <li>OfObject</li>
     * <li>LoadBalancingObject</li>
     * <li>LspaObject</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BandwidthObject) {
            this._bandwidth = ((BandwidthObject)arg).getBandwidth();
            isValidArg = true;
        }
        if (arg instanceof OfObject) {
            this._of = ((OfObject)arg).getOf();
            isValidArg = true;
        }
        if (arg instanceof LoadBalancingObject) {
            this._loadBalancing = ((LoadBalancingObject)arg).getLoadBalancing();
            isValidArg = true;
        }
        if (arg instanceof LspaObject) {
            this._lspa = ((LspaObject)arg).getLspa();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[BandwidthObject, OfObject, LoadBalancingObject, LspaObject]");
    }

    public Bandwidth getBandwidth() {
        return _bandwidth;
    }
    
    public List<EndpointRroPair> getEndpointRroPair() {
        return _endpointRroPair;
    }
    
    public IroBncChoice getIroBncChoice() {
        return _iroBncChoice;
    }
    
    public LoadBalancing getLoadBalancing() {
        return _loadBalancing;
    }
    
    public Lspa getLspa() {
        return _lspa;
    }
    
    public List<Metric> getMetric() {
        return _metric;
    }
    
    public Of getOf() {
        return _of;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<P2mp>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public P2mpBuilder setBandwidth(final Bandwidth value) {
        this._bandwidth = value;
        return this;
    }
    public P2mpBuilder setEndpointRroPair(final List<EndpointRroPair> values) {
        this._endpointRroPair = values;
        return this;
    }
    
    
    public P2mpBuilder setIroBncChoice(final IroBncChoice value) {
        this._iroBncChoice = value;
        return this;
    }
    
    public P2mpBuilder setLoadBalancing(final LoadBalancing value) {
        this._loadBalancing = value;
        return this;
    }
    
    public P2mpBuilder setLspa(final Lspa value) {
        this._lspa = value;
        return this;
    }
    public P2mpBuilder setMetric(final List<Metric> values) {
        this._metric = values;
        return this;
    }
    
    
    public P2mpBuilder setOf(final Of value) {
        this._of = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public P2mpBuilder addAugmentation(Augmentation<P2mp> augmentation) {
        Class<? extends Augmentation<P2mp>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public P2mpBuilder removeAugmentation(Class<? extends Augmentation<P2mp>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public P2mp build() {
        return new P2mpImpl(this);
    }

    private static final class P2mpImpl
        extends AbstractAugmentable<P2mp>
        implements P2mp {
    
        private final Bandwidth _bandwidth;
        private final List<EndpointRroPair> _endpointRroPair;
        private final IroBncChoice _iroBncChoice;
        private final LoadBalancing _loadBalancing;
        private final Lspa _lspa;
        private final List<Metric> _metric;
        private final Of _of;
    
        P2mpImpl(P2mpBuilder base) {
            super(base.augmentation);
            this._bandwidth = base.getBandwidth();
            this._endpointRroPair = CodeHelpers.emptyToNull(base.getEndpointRroPair());
            this._iroBncChoice = base.getIroBncChoice();
            this._loadBalancing = base.getLoadBalancing();
            this._lspa = base.getLspa();
            this._metric = CodeHelpers.emptyToNull(base.getMetric());
            this._of = base.getOf();
        }
    
        @Override
        public Bandwidth getBandwidth() {
            return _bandwidth;
        }
        
        @Override
        public List<EndpointRroPair> getEndpointRroPair() {
            return _endpointRroPair;
        }
        
        @Override
        public IroBncChoice getIroBncChoice() {
            return _iroBncChoice;
        }
        
        @Override
        public LoadBalancing getLoadBalancing() {
            return _loadBalancing;
        }
        
        @Override
        public Lspa getLspa() {
            return _lspa;
        }
        
        @Override
        public List<Metric> getMetric() {
            return _metric;
        }
        
        @Override
        public Of getOf() {
            return _of;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = P2mp.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return P2mp.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return P2mp.bindingToString(this);
        }
    }
}
