package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.EndpointsObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.LoadBalancingObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.LspAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.VendorInformationObjects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.SegmentComputation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2p.ReportedRoute;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container p2p {
 *   when "../rp/p2mp = false";
 *   uses endpoints-object;
 *   container reported-route {
 *     uses reported-route-object;
 *     uses reoptimization-bandwidth-object;
 *   }
 *   uses vendor-information-objects;
 *   uses load-balancing-object;
 *   uses lsp-attributes;
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typespcreq-messagepcreq-messagerequestssegment-computationp2p</i>
 *
 * <p>To create instances of this class use {@link P2pBuilder}.
 * @see P2pBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface P2p
    extends
    ChildOf<SegmentComputation>,
    Augmentable<P2p>,
    EndpointsObject,
    VendorInformationObjects,
    LoadBalancingObject,
    LspAttributes
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("p2p");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.P2p> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.P2p.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.@NonNull P2p obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getBandwidth());
        result = prime * result + Objects.hashCode(obj.getClassType());
        result = prime * result + Objects.hashCode(obj.getEndpointsObj());
        result = prime * result + Objects.hashCode(obj.getIro());
        result = prime * result + Objects.hashCode(obj.getLoadBalancing());
        result = prime * result + Objects.hashCode(obj.getLspa());
        result = prime * result + Objects.hashCode(obj.getMetrics());
        result = prime * result + Objects.hashCode(obj.getOf());
        result = prime * result + Objects.hashCode(obj.getReoptimizationBandwidth());
        result = prime * result + Objects.hashCode(obj.getReportedRoute());
        result = prime * result + Objects.hashCode(obj.getRro());
        result = prime * result + Objects.hashCode(obj.getVendorInformationObject());
        result = prime * result + Objects.hashCode(obj.getXro());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.@NonNull P2p thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.P2p other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.P2p.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getBandwidth(), other.getBandwidth())) {
            return false;
        }
        if (!Objects.equals(thisObj.getClassType(), other.getClassType())) {
            return false;
        }
        if (!Objects.equals(thisObj.getEndpointsObj(), other.getEndpointsObj())) {
            return false;
        }
        if (!Objects.equals(thisObj.getIro(), other.getIro())) {
            return false;
        }
        if (!Objects.equals(thisObj.getLoadBalancing(), other.getLoadBalancing())) {
            return false;
        }
        if (!Objects.equals(thisObj.getLspa(), other.getLspa())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMetrics(), other.getMetrics())) {
            return false;
        }
        if (!Objects.equals(thisObj.getOf(), other.getOf())) {
            return false;
        }
        if (!Objects.equals(thisObj.getReoptimizationBandwidth(), other.getReoptimizationBandwidth())) {
            return false;
        }
        if (!Objects.equals(thisObj.getReportedRoute(), other.getReportedRoute())) {
            return false;
        }
        if (!Objects.equals(thisObj.getRro(), other.getRro())) {
            return false;
        }
        if (!Objects.equals(thisObj.getVendorInformationObject(), other.getVendorInformationObject())) {
            return false;
        }
        if (!Objects.equals(thisObj.getXro(), other.getXro())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.@NonNull P2p obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("P2p");
        CodeHelpers.appendValue(helper, "bandwidth", obj.getBandwidth());
        CodeHelpers.appendValue(helper, "classType", obj.getClassType());
        CodeHelpers.appendValue(helper, "endpointsObj", obj.getEndpointsObj());
        CodeHelpers.appendValue(helper, "iro", obj.getIro());
        CodeHelpers.appendValue(helper, "loadBalancing", obj.getLoadBalancing());
        CodeHelpers.appendValue(helper, "lspa", obj.getLspa());
        CodeHelpers.appendValue(helper, "metrics", obj.getMetrics());
        CodeHelpers.appendValue(helper, "of", obj.getOf());
        CodeHelpers.appendValue(helper, "reoptimizationBandwidth", obj.getReoptimizationBandwidth());
        CodeHelpers.appendValue(helper, "reportedRoute", obj.getReportedRoute());
        CodeHelpers.appendValue(helper, "rro", obj.getRro());
        CodeHelpers.appendValue(helper, "vendorInformationObject", obj.getVendorInformationObject());
        CodeHelpers.appendValue(helper, "xro", obj.getXro());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return reportedRoute, or {@code null} if it is not present.
     *
     * @return {@code ReportedRoute} reportedRoute, or {@code null} if it is not present.
     *
     */
    ReportedRoute getReportedRoute();

}

