package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.BandwidthObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ClasstypeObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.EndpointsObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ExcludeRouteObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.IncludeRouteObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.LoadBalancingObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.LspAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.LspaObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.OfObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ReoptimizationBandwidthObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ReportedRouteObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.VendorInformationObjects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bandwidth.object.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.classtype.object.ClassType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.object.EndpointsObj;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.Xro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.Iro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.load.balancing.object.LoadBalancing;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lsp.attributes.Metrics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.Lspa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.object.Of;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2p.ReportedRoute;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reoptimization.bandwidth.object.ReoptimizationBandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.Rro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.objects.VendorInformationObject;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link P2pBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     P2pBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new P2pBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of P2pBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see P2pBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class P2pBuilder implements Builder<P2p> {

    private Bandwidth _bandwidth;
    private ClassType _classType;
    private EndpointsObj _endpointsObj;
    private Iro _iro;
    private LoadBalancing _loadBalancing;
    private Lspa _lspa;
    private List<Metrics> _metrics;
    private Of _of;
    private ReoptimizationBandwidth _reoptimizationBandwidth;
    private ReportedRoute _reportedRoute;
    private Rro _rro;
    private List<VendorInformationObject> _vendorInformationObject;
    private Xro _xro;


    Map<Class<? extends Augmentation<P2p>>, Augmentation<P2p>> augmentation = Collections.emptyMap();

    public P2pBuilder() {
    }
    
    
    
    public P2pBuilder(EndpointsObject arg) {
        this._endpointsObj = arg.getEndpointsObj();
    }
    
    public P2pBuilder(VendorInformationObjects arg) {
        this._vendorInformationObject = arg.getVendorInformationObject();
    }
    
    public P2pBuilder(LoadBalancingObject arg) {
        this._loadBalancing = arg.getLoadBalancing();
    }
    
    public P2pBuilder(LspAttributes arg) {
        this._metrics = arg.getMetrics();
        this._lspa = arg.getLspa();
        this._bandwidth = arg.getBandwidth();
        this._reoptimizationBandwidth = arg.getReoptimizationBandwidth();
        this._iro = arg.getIro();
        this._rro = arg.getRro();
        this._xro = arg.getXro();
        this._of = arg.getOf();
        this._classType = arg.getClassType();
    }
    public P2pBuilder(LspaObject arg) {
        this._lspa = arg.getLspa();
    }
    public P2pBuilder(BandwidthObject arg) {
        this._bandwidth = arg.getBandwidth();
    }
    public P2pBuilder(ReoptimizationBandwidthObject arg) {
        this._reoptimizationBandwidth = arg.getReoptimizationBandwidth();
    }
    public P2pBuilder(IncludeRouteObject arg) {
        this._iro = arg.getIro();
    }
    public P2pBuilder(ReportedRouteObject arg) {
        this._rro = arg.getRro();
    }
    public P2pBuilder(ExcludeRouteObject arg) {
        this._xro = arg.getXro();
    }
    public P2pBuilder(OfObject arg) {
        this._of = arg.getOf();
    }
    public P2pBuilder(ClasstypeObject arg) {
        this._classType = arg.getClassType();
    }

    public P2pBuilder(P2p base) {
        Map<Class<? extends Augmentation<P2p>>, Augmentation<P2p>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._bandwidth = base.getBandwidth();
        this._classType = base.getClassType();
        this._endpointsObj = base.getEndpointsObj();
        this._iro = base.getIro();
        this._loadBalancing = base.getLoadBalancing();
        this._lspa = base.getLspa();
        this._metrics = base.getMetrics();
        this._of = base.getOf();
        this._reoptimizationBandwidth = base.getReoptimizationBandwidth();
        this._reportedRoute = base.getReportedRoute();
        this._rro = base.getRro();
        this._vendorInformationObject = base.getVendorInformationObject();
        this._xro = base.getXro();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>ClasstypeObject</li>
     * <li>ReoptimizationBandwidthObject</li>
     * <li>BandwidthObject</li>
     * <li>OfObject</li>
     * <li>ReportedRouteObject</li>
     * <li>EndpointsObject</li>
     * <li>LoadBalancingObject</li>
     * <li>LspAttributes</li>
     * <li>IncludeRouteObject</li>
     * <li>ExcludeRouteObject</li>
     * <li>VendorInformationObjects</li>
     * <li>LspaObject</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ClasstypeObject) {
            this._classType = ((ClasstypeObject)arg).getClassType();
            isValidArg = true;
        }
        if (arg instanceof ReoptimizationBandwidthObject) {
            this._reoptimizationBandwidth = ((ReoptimizationBandwidthObject)arg).getReoptimizationBandwidth();
            isValidArg = true;
        }
        if (arg instanceof BandwidthObject) {
            this._bandwidth = ((BandwidthObject)arg).getBandwidth();
            isValidArg = true;
        }
        if (arg instanceof OfObject) {
            this._of = ((OfObject)arg).getOf();
            isValidArg = true;
        }
        if (arg instanceof ReportedRouteObject) {
            this._rro = ((ReportedRouteObject)arg).getRro();
            isValidArg = true;
        }
        if (arg instanceof EndpointsObject) {
            this._endpointsObj = ((EndpointsObject)arg).getEndpointsObj();
            isValidArg = true;
        }
        if (arg instanceof LoadBalancingObject) {
            this._loadBalancing = ((LoadBalancingObject)arg).getLoadBalancing();
            isValidArg = true;
        }
        if (arg instanceof LspAttributes) {
            this._metrics = ((LspAttributes)arg).getMetrics();
            isValidArg = true;
        }
        if (arg instanceof IncludeRouteObject) {
            this._iro = ((IncludeRouteObject)arg).getIro();
            isValidArg = true;
        }
        if (arg instanceof ExcludeRouteObject) {
            this._xro = ((ExcludeRouteObject)arg).getXro();
            isValidArg = true;
        }
        if (arg instanceof VendorInformationObjects) {
            this._vendorInformationObject = ((VendorInformationObjects)arg).getVendorInformationObject();
            isValidArg = true;
        }
        if (arg instanceof LspaObject) {
            this._lspa = ((LspaObject)arg).getLspa();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[ClasstypeObject, ReoptimizationBandwidthObject, BandwidthObject, OfObject, ReportedRouteObject, EndpointsObject, LoadBalancingObject, LspAttributes, IncludeRouteObject, ExcludeRouteObject, VendorInformationObjects, LspaObject]");
    }

    public Bandwidth getBandwidth() {
        return _bandwidth;
    }
    
    public ClassType getClassType() {
        return _classType;
    }
    
    public EndpointsObj getEndpointsObj() {
        return _endpointsObj;
    }
    
    public Iro getIro() {
        return _iro;
    }
    
    public LoadBalancing getLoadBalancing() {
        return _loadBalancing;
    }
    
    public Lspa getLspa() {
        return _lspa;
    }
    
    public List<Metrics> getMetrics() {
        return _metrics;
    }
    
    public Of getOf() {
        return _of;
    }
    
    public ReoptimizationBandwidth getReoptimizationBandwidth() {
        return _reoptimizationBandwidth;
    }
    
    public ReportedRoute getReportedRoute() {
        return _reportedRoute;
    }
    
    public Rro getRro() {
        return _rro;
    }
    
    public List<VendorInformationObject> getVendorInformationObject() {
        return _vendorInformationObject;
    }
    
    public Xro getXro() {
        return _xro;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<P2p>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public P2pBuilder setBandwidth(final Bandwidth value) {
        this._bandwidth = value;
        return this;
    }
    
    public P2pBuilder setClassType(final ClassType value) {
        this._classType = value;
        return this;
    }
    
    public P2pBuilder setEndpointsObj(final EndpointsObj value) {
        this._endpointsObj = value;
        return this;
    }
    
    public P2pBuilder setIro(final Iro value) {
        this._iro = value;
        return this;
    }
    
    public P2pBuilder setLoadBalancing(final LoadBalancing value) {
        this._loadBalancing = value;
        return this;
    }
    
    public P2pBuilder setLspa(final Lspa value) {
        this._lspa = value;
        return this;
    }
    public P2pBuilder setMetrics(final List<Metrics> values) {
        this._metrics = values;
        return this;
    }
    
    
    public P2pBuilder setOf(final Of value) {
        this._of = value;
        return this;
    }
    
    public P2pBuilder setReoptimizationBandwidth(final ReoptimizationBandwidth value) {
        this._reoptimizationBandwidth = value;
        return this;
    }
    
    public P2pBuilder setReportedRoute(final ReportedRoute value) {
        this._reportedRoute = value;
        return this;
    }
    
    public P2pBuilder setRro(final Rro value) {
        this._rro = value;
        return this;
    }
    public P2pBuilder setVendorInformationObject(final List<VendorInformationObject> values) {
        this._vendorInformationObject = values;
        return this;
    }
    
    
    public P2pBuilder setXro(final Xro value) {
        this._xro = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public P2pBuilder addAugmentation(Augmentation<P2p> augmentation) {
        Class<? extends Augmentation<P2p>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public P2pBuilder removeAugmentation(Class<? extends Augmentation<P2p>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public P2p build() {
        return new P2pImpl(this);
    }

    private static final class P2pImpl
        extends AbstractAugmentable<P2p>
        implements P2p {
    
        private final Bandwidth _bandwidth;
        private final ClassType _classType;
        private final EndpointsObj _endpointsObj;
        private final Iro _iro;
        private final LoadBalancing _loadBalancing;
        private final Lspa _lspa;
        private final List<Metrics> _metrics;
        private final Of _of;
        private final ReoptimizationBandwidth _reoptimizationBandwidth;
        private final ReportedRoute _reportedRoute;
        private final Rro _rro;
        private final List<VendorInformationObject> _vendorInformationObject;
        private final Xro _xro;
    
        P2pImpl(P2pBuilder base) {
            super(base.augmentation);
            this._bandwidth = base.getBandwidth();
            this._classType = base.getClassType();
            this._endpointsObj = base.getEndpointsObj();
            this._iro = base.getIro();
            this._loadBalancing = base.getLoadBalancing();
            this._lspa = base.getLspa();
            this._metrics = CodeHelpers.emptyToNull(base.getMetrics());
            this._of = base.getOf();
            this._reoptimizationBandwidth = base.getReoptimizationBandwidth();
            this._reportedRoute = base.getReportedRoute();
            this._rro = base.getRro();
            this._vendorInformationObject = CodeHelpers.emptyToNull(base.getVendorInformationObject());
            this._xro = base.getXro();
        }
    
        @Override
        public Bandwidth getBandwidth() {
            return _bandwidth;
        }
        
        @Override
        public ClassType getClassType() {
            return _classType;
        }
        
        @Override
        public EndpointsObj getEndpointsObj() {
            return _endpointsObj;
        }
        
        @Override
        public Iro getIro() {
            return _iro;
        }
        
        @Override
        public LoadBalancing getLoadBalancing() {
            return _loadBalancing;
        }
        
        @Override
        public Lspa getLspa() {
            return _lspa;
        }
        
        @Override
        public List<Metrics> getMetrics() {
            return _metrics;
        }
        
        @Override
        public Of getOf() {
            return _of;
        }
        
        @Override
        public ReoptimizationBandwidth getReoptimizationBandwidth() {
            return _reoptimizationBandwidth;
        }
        
        @Override
        public ReportedRoute getReportedRoute() {
            return _reportedRoute;
        }
        
        @Override
        public Rro getRro() {
            return _rro;
        }
        
        @Override
        public List<VendorInformationObject> getVendorInformationObject() {
            return _vendorInformationObject;
        }
        
        @Override
        public Xro getXro() {
            return _xro;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = P2p.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return P2p.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return P2p.bindingToString(this);
        }
    }
}
