package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.EndpointsObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ReoptimizationBandwidthObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.P2mp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.endpoint.rro.pair.Rros;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * list endpoint-rro-pair {
 *   uses endpoints-object;
 *   list rros {
 *     choice route-object {
 *       case reported-route-object-case {
 *         uses reported-route-object;
 *       }
 *       case secondary-reported-route-object-case {
 *         uses secondary-reported-route-object;
 *       }
 *     }
 *   }
 *   uses reoptimization-bandwidth-object;
 *   min-elements 1;
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typespcreq-messagepcreq-messagerequestssegment-computationp2mpendpoint-rro-pair</i>
 *
 * <p>To create instances of this class use {@link EndpointRroPairBuilder}.
 * @see EndpointRroPairBuilder
 *
 *
 */
@Generated("mdsal-binding-generator")
public interface EndpointRroPair
    extends
    ChildOf<P2mp>,
    Augmentable<EndpointRroPair>,
    EndpointsObject,
    ReoptimizationBandwidthObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("endpoint-rro-pair");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.EndpointRroPair> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.EndpointRroPair.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.@NonNull EndpointRroPair obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getEndpointsObj());
        result = prime * result + Objects.hashCode(obj.getReoptimizationBandwidth());
        result = prime * result + Objects.hashCode(obj.getRros());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.@NonNull EndpointRroPair thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.EndpointRroPair other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.EndpointRroPair.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getEndpointsObj(), other.getEndpointsObj())) {
            return false;
        }
        if (!Objects.equals(thisObj.getReoptimizationBandwidth(), other.getReoptimizationBandwidth())) {
            return false;
        }
        if (!Objects.equals(thisObj.getRros(), other.getRros())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.@NonNull EndpointRroPair obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("EndpointRroPair");
        CodeHelpers.appendValue(helper, "endpointsObj", obj.getEndpointsObj());
        CodeHelpers.appendValue(helper, "reoptimizationBandwidth", obj.getReoptimizationBandwidth());
        CodeHelpers.appendValue(helper, "rros", obj.getRros());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return rros, or {@code null} if it is not present.
     *
     * @return {@code List<Rros>} rros, or {@code null} if it is not present.
     *
     */
    @Nullable List<Rros> getRros();
    
    /**
     * Return rros, or an empty list if it is not present.
     *
     * @return {@code List<Rros>} rros, or an empty list if it is not present.
     *
     */
    default @NonNull List<Rros> nonnullRros() {
        return CodeHelpers.nonnull(getRros());
    }

}

