package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.EndpointsObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ReoptimizationBandwidthObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.object.EndpointsObj;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.endpoint.rro.pair.Rros;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reoptimization.bandwidth.object.ReoptimizationBandwidth;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link EndpointRroPairBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     EndpointRroPairBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new EndpointRroPairBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of EndpointRroPairBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see EndpointRroPairBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class EndpointRroPairBuilder implements Builder<EndpointRroPair> {

    private EndpointsObj _endpointsObj;
    private ReoptimizationBandwidth _reoptimizationBandwidth;
    private List<Rros> _rros;


    Map<Class<? extends Augmentation<EndpointRroPair>>, Augmentation<EndpointRroPair>> augmentation = Collections.emptyMap();

    public EndpointRroPairBuilder() {
    }
    
    
    
    public EndpointRroPairBuilder(EndpointsObject arg) {
        this._endpointsObj = arg.getEndpointsObj();
    }
    
    public EndpointRroPairBuilder(ReoptimizationBandwidthObject arg) {
        this._reoptimizationBandwidth = arg.getReoptimizationBandwidth();
    }

    public EndpointRroPairBuilder(EndpointRroPair base) {
        Map<Class<? extends Augmentation<EndpointRroPair>>, Augmentation<EndpointRroPair>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._endpointsObj = base.getEndpointsObj();
        this._reoptimizationBandwidth = base.getReoptimizationBandwidth();
        this._rros = base.getRros();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>ReoptimizationBandwidthObject</li>
     * <li>EndpointsObject</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ReoptimizationBandwidthObject) {
            this._reoptimizationBandwidth = ((ReoptimizationBandwidthObject)arg).getReoptimizationBandwidth();
            isValidArg = true;
        }
        if (arg instanceof EndpointsObject) {
            this._endpointsObj = ((EndpointsObject)arg).getEndpointsObj();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[ReoptimizationBandwidthObject, EndpointsObject]");
    }

    public EndpointsObj getEndpointsObj() {
        return _endpointsObj;
    }
    
    public ReoptimizationBandwidth getReoptimizationBandwidth() {
        return _reoptimizationBandwidth;
    }
    
    public List<Rros> getRros() {
        return _rros;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<EndpointRroPair>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public EndpointRroPairBuilder setEndpointsObj(final EndpointsObj value) {
        this._endpointsObj = value;
        return this;
    }
    
    public EndpointRroPairBuilder setReoptimizationBandwidth(final ReoptimizationBandwidth value) {
        this._reoptimizationBandwidth = value;
        return this;
    }
    public EndpointRroPairBuilder setRros(final List<Rros> values) {
        this._rros = values;
        return this;
    }
    
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public EndpointRroPairBuilder addAugmentation(Augmentation<EndpointRroPair> augmentation) {
        Class<? extends Augmentation<EndpointRroPair>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public EndpointRroPairBuilder removeAugmentation(Class<? extends Augmentation<EndpointRroPair>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public EndpointRroPair build() {
        return new EndpointRroPairImpl(this);
    }

    private static final class EndpointRroPairImpl
        extends AbstractAugmentable<EndpointRroPair>
        implements EndpointRroPair {
    
        private final EndpointsObj _endpointsObj;
        private final ReoptimizationBandwidth _reoptimizationBandwidth;
        private final List<Rros> _rros;
    
        EndpointRroPairImpl(EndpointRroPairBuilder base) {
            super(base.augmentation);
            this._endpointsObj = base.getEndpointsObj();
            this._reoptimizationBandwidth = base.getReoptimizationBandwidth();
            this._rros = CodeHelpers.emptyToNull(base.getRros());
        }
    
        @Override
        public EndpointsObj getEndpointsObj() {
            return _endpointsObj;
        }
        
        @Override
        public ReoptimizationBandwidth getReoptimizationBandwidth() {
            return _reoptimizationBandwidth;
        }
        
        @Override
        public List<Rros> getRros() {
            return _rros;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = EndpointRroPair.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return EndpointRroPair.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return EndpointRroPair.bindingToString(this);
        }
    }
}
