package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2p;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ReoptimizationBandwidthObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ReportedRouteObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reoptimization.bandwidth.object.ReoptimizationBandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.Rro;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link ReportedRouteBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     ReportedRouteBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new ReportedRouteBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of ReportedRouteBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see ReportedRouteBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class ReportedRouteBuilder implements Builder<ReportedRoute> {

    private ReoptimizationBandwidth _reoptimizationBandwidth;
    private Rro _rro;


    Map<Class<? extends Augmentation<ReportedRoute>>, Augmentation<ReportedRoute>> augmentation = Collections.emptyMap();

    public ReportedRouteBuilder() {
    }
    
    
    
    public ReportedRouteBuilder(ReportedRouteObject arg) {
        this._rro = arg.getRro();
    }
    
    public ReportedRouteBuilder(ReoptimizationBandwidthObject arg) {
        this._reoptimizationBandwidth = arg.getReoptimizationBandwidth();
    }

    public ReportedRouteBuilder(ReportedRoute base) {
        Map<Class<? extends Augmentation<ReportedRoute>>, Augmentation<ReportedRoute>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._reoptimizationBandwidth = base.getReoptimizationBandwidth();
        this._rro = base.getRro();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>ReoptimizationBandwidthObject</li>
     * <li>ReportedRouteObject</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ReoptimizationBandwidthObject) {
            this._reoptimizationBandwidth = ((ReoptimizationBandwidthObject)arg).getReoptimizationBandwidth();
            isValidArg = true;
        }
        if (arg instanceof ReportedRouteObject) {
            this._rro = ((ReportedRouteObject)arg).getRro();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[ReoptimizationBandwidthObject, ReportedRouteObject]");
    }

    public ReoptimizationBandwidth getReoptimizationBandwidth() {
        return _reoptimizationBandwidth;
    }
    
    public Rro getRro() {
        return _rro;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ReportedRoute>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public ReportedRouteBuilder setReoptimizationBandwidth(final ReoptimizationBandwidth value) {
        this._reoptimizationBandwidth = value;
        return this;
    }
    
    public ReportedRouteBuilder setRro(final Rro value) {
        this._rro = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ReportedRouteBuilder addAugmentation(Augmentation<ReportedRoute> augmentation) {
        Class<? extends Augmentation<ReportedRoute>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ReportedRouteBuilder removeAugmentation(Class<? extends Augmentation<ReportedRoute>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public ReportedRoute build() {
        return new ReportedRouteImpl(this);
    }

    private static final class ReportedRouteImpl
        extends AbstractAugmentable<ReportedRoute>
        implements ReportedRoute {
    
        private final ReoptimizationBandwidth _reoptimizationBandwidth;
        private final Rro _rro;
    
        ReportedRouteImpl(ReportedRouteBuilder base) {
            super(base.augmentation);
            this._reoptimizationBandwidth = base.getReoptimizationBandwidth();
            this._rro = base.getRro();
        }
    
        @Override
        public ReoptimizationBandwidth getReoptimizationBandwidth() {
            return _reoptimizationBandwidth;
        }
        
        @Override
        public Rro getRro() {
            return _rro;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = ReportedRoute.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return ReportedRoute.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return ReportedRoute.bindingToString(this);
        }
    }
}
