package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.proc.time.object;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ProcTimeObject;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container proc-time {
 *   uses object;
 *   leaf estimated {
 *     type boolean;
 *   }
 *   leaf current-proc-time {
 *     type uint32;
 *   }
 *   leaf min-proc-time {
 *     type uint32;
 *   }
 *   leaf max-proc-time {
 *     type uint32;
 *   }
 *   leaf average-proc-time {
 *     type uint32;
 *   }
 *   leaf variance-proc-time {
 *     type uint32;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typesproc-time-objectproc-time</i>
 *
 * <p>To create instances of this class use {@link ProcTimeBuilder}.
 * @see ProcTimeBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface ProcTime
    extends
    ChildOf<ProcTimeObject>,
    Augmentable<ProcTime>,
    Object
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("proc-time");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.proc.time.object.ProcTime> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.proc.time.object.ProcTime.class;
    }
    
    /**
     * Default implementation of {@link java.lang.Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.proc.time.object.@NonNull ProcTime obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAverageProcTime());
        result = prime * result + Objects.hashCode(obj.getCurrentProcTime());
        result = prime * result + Objects.hashCode(obj.getEstimated());
        result = prime * result + Objects.hashCode(obj.getIgnore());
        result = prime * result + Objects.hashCode(obj.getMaxProcTime());
        result = prime * result + Objects.hashCode(obj.getMinProcTime());
        result = prime * result + Objects.hashCode(obj.getProcessingRule());
        result = prime * result + Objects.hashCode(obj.getVarianceProcTime());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link java.lang.Object#equals(java.lang.Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.proc.time.object.@NonNull ProcTime thisObj, final java.lang.Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.proc.time.object.ProcTime other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.proc.time.object.ProcTime.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getAverageProcTime(), other.getAverageProcTime())) {
            return false;
        }
        if (!Objects.equals(thisObj.getCurrentProcTime(), other.getCurrentProcTime())) {
            return false;
        }
        if (!Objects.equals(thisObj.getEstimated(), other.getEstimated())) {
            return false;
        }
        if (!Objects.equals(thisObj.getIgnore(), other.getIgnore())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMaxProcTime(), other.getMaxProcTime())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMinProcTime(), other.getMinProcTime())) {
            return false;
        }
        if (!Objects.equals(thisObj.getProcessingRule(), other.getProcessingRule())) {
            return false;
        }
        if (!Objects.equals(thisObj.getVarianceProcTime(), other.getVarianceProcTime())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link java.lang.Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.proc.time.object.@NonNull ProcTime obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("ProcTime");
        CodeHelpers.appendValue(helper, "averageProcTime", obj.getAverageProcTime());
        CodeHelpers.appendValue(helper, "currentProcTime", obj.getCurrentProcTime());
        CodeHelpers.appendValue(helper, "estimated", obj.getEstimated());
        CodeHelpers.appendValue(helper, "ignore", obj.getIgnore());
        CodeHelpers.appendValue(helper, "maxProcTime", obj.getMaxProcTime());
        CodeHelpers.appendValue(helper, "minProcTime", obj.getMinProcTime());
        CodeHelpers.appendValue(helper, "processingRule", obj.getProcessingRule());
        CodeHelpers.appendValue(helper, "varianceProcTime", obj.getVarianceProcTime());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return estimated, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Indicates that the reported metric value is based on estimated processing time
     *         as opposed to actual computations.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} estimated, or {@code null} if it is not present.
     *
     */
    Boolean getEstimated();
    
    /**
     * Return estimated, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Indicates that the reported metric value is based on estimated processing time
     *         as opposed to actual computations.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} estimated, guaranteed to be non-null.
     * @throws NoSuchElementException if estimated is not present
     *
     */
    default @NonNull Boolean requireEstimated() {
        return CodeHelpers.require(getEstimated(), "estimated");
    }
    
    /**
     * Return currentProcTime, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Indicates, in milliseconds, the processing time for the path computation of
     *         interest characterized in the corresponding PCMonReq message.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} currentProcTime, or {@code null} if it is not present.
     *
     */
    Uint32 getCurrentProcTime();
    
    /**
     * Return currentProcTime, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Indicates, in milliseconds, the processing time for the path computation of
     *         interest characterized in the corresponding PCMonReq message.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} currentProcTime, guaranteed to be non-null.
     * @throws NoSuchElementException if currentProcTime is not present
     *
     */
    default @NonNull Uint32 requireCurrentProcTime() {
        return CodeHelpers.require(getCurrentProcTime(), "currentproctime");
    }
    
    /**
     * Return minProcTime, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The minimum processing time in milliseconds
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} minProcTime, or {@code null} if it is not present.
     *
     */
    Uint32 getMinProcTime();
    
    /**
     * Return minProcTime, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The minimum processing time in milliseconds
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} minProcTime, guaranteed to be non-null.
     * @throws NoSuchElementException if minProcTime is not present
     *
     */
    default @NonNull Uint32 requireMinProcTime() {
        return CodeHelpers.require(getMinProcTime(), "minproctime");
    }
    
    /**
     * Return maxProcTime, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The maximum processing time in milliseconds
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} maxProcTime, or {@code null} if it is not present.
     *
     */
    Uint32 getMaxProcTime();
    
    /**
     * Return maxProcTime, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The maximum processing time in milliseconds
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} maxProcTime, guaranteed to be non-null.
     * @throws NoSuchElementException if maxProcTime is not present
     *
     */
    default @NonNull Uint32 requireMaxProcTime() {
        return CodeHelpers.require(getMaxProcTime(), "maxproctime");
    }
    
    /**
     * Return averageProcTime, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The average processing time in milliseconds
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} averageProcTime, or {@code null} if it is not present.
     *
     */
    Uint32 getAverageProcTime();
    
    /**
     * Return averageProcTime, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The average processing time in milliseconds
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} averageProcTime, guaranteed to be non-null.
     * @throws NoSuchElementException if averageProcTime is not present
     *
     */
    default @NonNull Uint32 requireAverageProcTime() {
        return CodeHelpers.require(getAverageProcTime(), "averageproctime");
    }
    
    /**
     * Return varianceProcTime, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The variance of processing times in milliseconds
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} varianceProcTime, or {@code null} if it is not present.
     *
     */
    Uint32 getVarianceProcTime();
    
    /**
     * Return varianceProcTime, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The variance of processing times in milliseconds
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} varianceProcTime, guaranteed to be non-null.
     * @throws NoSuchElementException if varianceProcTime is not present
     *
     */
    default @NonNull Uint32 requireVarianceProcTime() {
        return CodeHelpers.require(getVarianceProcTime(), "varianceproctime");
    }

}

