package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.proc.time.object;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link ProcTimeBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     ProcTimeBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new ProcTimeBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of ProcTimeBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see ProcTimeBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class ProcTimeBuilder implements Builder<ProcTime> {

    private Uint32 _averageProcTime;
    private Uint32 _currentProcTime;
    private Boolean _estimated;
    private Boolean _ignore;
    private Uint32 _maxProcTime;
    private Uint32 _minProcTime;
    private Boolean _processingRule;
    private Uint32 _varianceProcTime;


    Map<Class<? extends Augmentation<ProcTime>>, Augmentation<ProcTime>> augmentation = Collections.emptyMap();

    public ProcTimeBuilder() {
    }
    
    
    
    public ProcTimeBuilder(Object arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }
    public ProcTimeBuilder(ObjectHeader arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public ProcTimeBuilder(ProcTime base) {
        Map<Class<? extends Augmentation<ProcTime>>, Augmentation<ProcTime>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._averageProcTime = base.getAverageProcTime();
        this._currentProcTime = base.getCurrentProcTime();
        this._estimated = base.getEstimated();
        this._ignore = base.getIgnore();
        this._maxProcTime = base.getMaxProcTime();
        this._minProcTime = base.getMinProcTime();
        this._processingRule = base.getProcessingRule();
        this._varianceProcTime = base.getVarianceProcTime();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>ObjectHeader</li>
     * <li>Object</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).getProcessingRule();
            this._ignore = ((ObjectHeader)arg).getIgnore();
            isValidArg = true;
        }
        if (arg instanceof Object) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[ObjectHeader, Object]");
    }

    public Uint32 getAverageProcTime() {
        return _averageProcTime;
    }
    
    public Uint32 getCurrentProcTime() {
        return _currentProcTime;
    }
    
    public Boolean getEstimated() {
        return _estimated;
    }
    
    public Boolean getIgnore() {
        return _ignore;
    }
    
    public Uint32 getMaxProcTime() {
        return _maxProcTime;
    }
    
    public Uint32 getMinProcTime() {
        return _minProcTime;
    }
    
    public Boolean getProcessingRule() {
        return _processingRule;
    }
    
    public Uint32 getVarianceProcTime() {
        return _varianceProcTime;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ProcTime>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public ProcTimeBuilder setAverageProcTime(final Uint32 value) {
        this._averageProcTime = value;
        return this;
    }
    
    public ProcTimeBuilder setCurrentProcTime(final Uint32 value) {
        this._currentProcTime = value;
        return this;
    }
    
    public ProcTimeBuilder setEstimated(final Boolean value) {
        this._estimated = value;
        return this;
    }
    
    public ProcTimeBuilder setIgnore(final Boolean value) {
        this._ignore = value;
        return this;
    }
    
    public ProcTimeBuilder setMaxProcTime(final Uint32 value) {
        this._maxProcTime = value;
        return this;
    }
    
    public ProcTimeBuilder setMinProcTime(final Uint32 value) {
        this._minProcTime = value;
        return this;
    }
    
    public ProcTimeBuilder setProcessingRule(final Boolean value) {
        this._processingRule = value;
        return this;
    }
    
    public ProcTimeBuilder setVarianceProcTime(final Uint32 value) {
        this._varianceProcTime = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ProcTimeBuilder addAugmentation(Augmentation<ProcTime> augmentation) {
        Class<? extends Augmentation<ProcTime>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ProcTimeBuilder removeAugmentation(Class<? extends Augmentation<ProcTime>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public ProcTime build() {
        return new ProcTimeImpl(this);
    }

    private static final class ProcTimeImpl
        extends AbstractAugmentable<ProcTime>
        implements ProcTime {
    
        private final Uint32 _averageProcTime;
        private final Uint32 _currentProcTime;
        private final Boolean _estimated;
        private final Boolean _ignore;
        private final Uint32 _maxProcTime;
        private final Uint32 _minProcTime;
        private final Boolean _processingRule;
        private final Uint32 _varianceProcTime;
    
        ProcTimeImpl(ProcTimeBuilder base) {
            super(base.augmentation);
            this._averageProcTime = base.getAverageProcTime();
            this._currentProcTime = base.getCurrentProcTime();
            this._estimated = base.getEstimated();
            this._ignore = base.getIgnore();
            this._maxProcTime = base.getMaxProcTime();
            this._minProcTime = base.getMinProcTime();
            this._processingRule = base.getProcessingRule();
            this._varianceProcTime = base.getVarianceProcTime();
        }
    
        @Override
        public Uint32 getAverageProcTime() {
            return _averageProcTime;
        }
        
        @Override
        public Uint32 getCurrentProcTime() {
            return _currentProcTime;
        }
        
        @Override
        public Boolean getEstimated() {
            return _estimated;
        }
        
        @Override
        public Boolean getIgnore() {
            return _ignore;
        }
        
        @Override
        public Uint32 getMaxProcTime() {
            return _maxProcTime;
        }
        
        @Override
        public Uint32 getMinProcTime() {
            return _minProcTime;
        }
        
        @Override
        public Boolean getProcessingRule() {
            return _processingRule;
        }
        
        @Override
        public Uint32 getVarianceProcTime() {
            return _varianceProcTime;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = ProcTime.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(java.lang.Object obj) {
            return ProcTime.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return ProcTime.bindingToString(this);
        }
    }
}
