package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.RequestId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.RpObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.rp.Tlvs;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container rp {
 *   uses object;
 *   container tlvs {
 *     uses order-tlv;
 *     uses vendor-information-tlvs;
 *     uses path-setup-type-tlv;
 *   }
 *   leaf priority {
 *     type uint8 {
 *       range 1..7;
 *     }
 *   }
 *   leaf request-id {
 *     type request-id;
 *   }
 *   leaf reoptimization {
 *     type boolean;
 *     default false;
 *   }
 *   leaf bi-directional {
 *     type boolean;
 *     default false;
 *   }
 *   leaf loose {
 *     type boolean;
 *     default false;
 *   }
 *   leaf path-key {
 *     type boolean;
 *     default false;
 *   }
 *   leaf fragmentation {
 *     type boolean;
 *     default false;
 *   }
 *   leaf p2mp {
 *     type boolean;
 *     default false;
 *   }
 *   leaf ero-compression {
 *     type boolean;
 *     default false;
 *   }
 *   leaf supply-of {
 *     type boolean;
 *     default false;
 *   }
 *   leaf order {
 *     type boolean;
 *     default false;
 *   }
 *   leaf make-before-break {
 *     type boolean;
 *     default false;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typesrp-objectrp</i>
 *
 * <p>To create instances of this class use {@link RpBuilder}.
 * @see RpBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Rp
    extends
    ChildOf<RpObject>,
    Augmentable<Rp>,
    Object
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("rp");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.Rp> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.Rp.class;
    }
    
    /**
     * Default implementation of {@link java.lang.Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.@NonNull Rp obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getBiDirectional());
        result = prime * result + Objects.hashCode(obj.getEroCompression());
        result = prime * result + Objects.hashCode(obj.getFragmentation());
        result = prime * result + Objects.hashCode(obj.getIgnore());
        result = prime * result + Objects.hashCode(obj.getLoose());
        result = prime * result + Objects.hashCode(obj.getMakeBeforeBreak());
        result = prime * result + Objects.hashCode(obj.getOrder());
        result = prime * result + Objects.hashCode(obj.getP2mp());
        result = prime * result + Objects.hashCode(obj.getPathKey());
        result = prime * result + Objects.hashCode(obj.getPriority());
        result = prime * result + Objects.hashCode(obj.getProcessingRule());
        result = prime * result + Objects.hashCode(obj.getReoptimization());
        result = prime * result + Objects.hashCode(obj.getRequestId());
        result = prime * result + Objects.hashCode(obj.getSupplyOf());
        result = prime * result + Objects.hashCode(obj.getTlvs());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link java.lang.Object#equals(java.lang.Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.@NonNull Rp thisObj, final java.lang.Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.Rp other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.Rp.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getBiDirectional(), other.getBiDirectional())) {
            return false;
        }
        if (!Objects.equals(thisObj.getEroCompression(), other.getEroCompression())) {
            return false;
        }
        if (!Objects.equals(thisObj.getFragmentation(), other.getFragmentation())) {
            return false;
        }
        if (!Objects.equals(thisObj.getIgnore(), other.getIgnore())) {
            return false;
        }
        if (!Objects.equals(thisObj.getLoose(), other.getLoose())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMakeBeforeBreak(), other.getMakeBeforeBreak())) {
            return false;
        }
        if (!Objects.equals(thisObj.getOrder(), other.getOrder())) {
            return false;
        }
        if (!Objects.equals(thisObj.getP2mp(), other.getP2mp())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPathKey(), other.getPathKey())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPriority(), other.getPriority())) {
            return false;
        }
        if (!Objects.equals(thisObj.getProcessingRule(), other.getProcessingRule())) {
            return false;
        }
        if (!Objects.equals(thisObj.getReoptimization(), other.getReoptimization())) {
            return false;
        }
        if (!Objects.equals(thisObj.getRequestId(), other.getRequestId())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSupplyOf(), other.getSupplyOf())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTlvs(), other.getTlvs())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link java.lang.Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.@NonNull Rp obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Rp");
        CodeHelpers.appendValue(helper, "biDirectional", obj.getBiDirectional());
        CodeHelpers.appendValue(helper, "eroCompression", obj.getEroCompression());
        CodeHelpers.appendValue(helper, "fragmentation", obj.getFragmentation());
        CodeHelpers.appendValue(helper, "ignore", obj.getIgnore());
        CodeHelpers.appendValue(helper, "loose", obj.getLoose());
        CodeHelpers.appendValue(helper, "makeBeforeBreak", obj.getMakeBeforeBreak());
        CodeHelpers.appendValue(helper, "order", obj.getOrder());
        CodeHelpers.appendValue(helper, "p2mp", obj.getP2mp());
        CodeHelpers.appendValue(helper, "pathKey", obj.getPathKey());
        CodeHelpers.appendValue(helper, "priority", obj.getPriority());
        CodeHelpers.appendValue(helper, "processingRule", obj.getProcessingRule());
        CodeHelpers.appendValue(helper, "reoptimization", obj.getReoptimization());
        CodeHelpers.appendValue(helper, "requestId", obj.getRequestId());
        CodeHelpers.appendValue(helper, "supplyOf", obj.getSupplyOf());
        CodeHelpers.appendValue(helper, "tlvs", obj.getTlvs());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return tlvs, or {@code null} if it is not present.
     *
     * @return {@code Tlvs} tlvs, or {@code null} if it is not present.
     *
     */
    Tlvs getTlvs();
    
    /**
     * Return priority, or {@code null} if it is not present.
     *
     * @return {@code Uint8} priority, or {@code null} if it is not present.
     *
     */
    Uint8 getPriority();
    
    /**
     * Return priority, guaranteed to be non-null.
     *
     * @return {@code Uint8} priority, guaranteed to be non-null.
     * @throws NoSuchElementException if priority is not present
     *
     */
    default @NonNull Uint8 requirePriority() {
        return CodeHelpers.require(getPriority(), "priority");
    }
    
    /**
     * Return requestId, or {@code null} if it is not present.
     *
     * @return {@code RequestId} requestId, or {@code null} if it is not present.
     *
     */
    RequestId getRequestId();
    
    /**
     * Return requestId, guaranteed to be non-null.
     *
     * @return {@code RequestId} requestId, guaranteed to be non-null.
     * @throws NoSuchElementException if requestId is not present
     *
     */
    default @NonNull RequestId requireRequestId() {
        return CodeHelpers.require(getRequestId(), "requestid");
    }
    
    /**
     * Return reoptimization, or {@code null} if it is not present.
     *
     * @return {@code Boolean} reoptimization, or {@code null} if it is not present.
     *
     */
    Boolean getReoptimization();
    
    /**
     * Return reoptimization, guaranteed to be non-null.
     *
     * @return {@code Boolean} reoptimization, guaranteed to be non-null.
     * @throws NoSuchElementException if reoptimization is not present
     *
     */
    default @NonNull Boolean requireReoptimization() {
        return CodeHelpers.require(getReoptimization(), "reoptimization");
    }
    
    /**
     * Return biDirectional, or {@code null} if it is not present.
     *
     * @return {@code Boolean} biDirectional, or {@code null} if it is not present.
     *
     */
    Boolean getBiDirectional();
    
    /**
     * Return biDirectional, guaranteed to be non-null.
     *
     * @return {@code Boolean} biDirectional, guaranteed to be non-null.
     * @throws NoSuchElementException if biDirectional is not present
     *
     */
    default @NonNull Boolean requireBiDirectional() {
        return CodeHelpers.require(getBiDirectional(), "bidirectional");
    }
    
    /**
     * Return loose, or {@code null} if it is not present.
     *
     * @return {@code Boolean} loose, or {@code null} if it is not present.
     *
     */
    Boolean getLoose();
    
    /**
     * Return loose, guaranteed to be non-null.
     *
     * @return {@code Boolean} loose, guaranteed to be non-null.
     * @throws NoSuchElementException if loose is not present
     *
     */
    default @NonNull Boolean requireLoose() {
        return CodeHelpers.require(getLoose(), "loose");
    }
    
    /**
     * Return pathKey, or {@code null} if it is not present.
     *
     * @return {@code Boolean} pathKey, or {@code null} if it is not present.
     *
     */
    Boolean getPathKey();
    
    /**
     * Return pathKey, guaranteed to be non-null.
     *
     * @return {@code Boolean} pathKey, guaranteed to be non-null.
     * @throws NoSuchElementException if pathKey is not present
     *
     */
    default @NonNull Boolean requirePathKey() {
        return CodeHelpers.require(getPathKey(), "pathkey");
    }
    
    /**
     * Return fragmentation, or {@code null} if it is not present.
     *
     * @return {@code Boolean} fragmentation, or {@code null} if it is not present.
     *
     */
    Boolean getFragmentation();
    
    /**
     * Return fragmentation, guaranteed to be non-null.
     *
     * @return {@code Boolean} fragmentation, guaranteed to be non-null.
     * @throws NoSuchElementException if fragmentation is not present
     *
     */
    default @NonNull Boolean requireFragmentation() {
        return CodeHelpers.require(getFragmentation(), "fragmentation");
    }
    
    /**
     * Return p2mp, or {@code null} if it is not present.
     *
     * @return {@code Boolean} p2mp, or {@code null} if it is not present.
     *
     */
    Boolean getP2mp();
    
    /**
     * Return p2mp, guaranteed to be non-null.
     *
     * @return {@code Boolean} p2mp, guaranteed to be non-null.
     * @throws NoSuchElementException if p2mp is not present
     *
     */
    default @NonNull Boolean requireP2mp() {
        return CodeHelpers.require(getP2mp(), "p2mp");
    }
    
    /**
     * Return eroCompression, or {@code null} if it is not present.
     *
     * @return {@code Boolean} eroCompression, or {@code null} if it is not present.
     *
     */
    Boolean getEroCompression();
    
    /**
     * Return eroCompression, guaranteed to be non-null.
     *
     * @return {@code Boolean} eroCompression, guaranteed to be non-null.
     * @throws NoSuchElementException if eroCompression is not present
     *
     */
    default @NonNull Boolean requireEroCompression() {
        return CodeHelpers.require(getEroCompression(), "erocompression");
    }
    
    /**
     * Return supplyOf, or {@code null} if it is not present.
     *
     * @return {@code Boolean} supplyOf, or {@code null} if it is not present.
     *
     */
    Boolean getSupplyOf();
    
    /**
     * Return supplyOf, guaranteed to be non-null.
     *
     * @return {@code Boolean} supplyOf, guaranteed to be non-null.
     * @throws NoSuchElementException if supplyOf is not present
     *
     */
    default @NonNull Boolean requireSupplyOf() {
        return CodeHelpers.require(getSupplyOf(), "supplyof");
    }
    
    /**
     * Return order, or {@code null} if it is not present.
     *
     * @return {@code Boolean} order, or {@code null} if it is not present.
     *
     */
    Boolean getOrder();
    
    /**
     * Return order, guaranteed to be non-null.
     *
     * @return {@code Boolean} order, guaranteed to be non-null.
     * @throws NoSuchElementException if order is not present
     *
     */
    default @NonNull Boolean requireOrder() {
        return CodeHelpers.require(getOrder(), "order");
    }
    
    /**
     * Return makeBeforeBreak, or {@code null} if it is not present.
     *
     * @return {@code Boolean} makeBeforeBreak, or {@code null} if it is not present.
     *
     */
    Boolean getMakeBeforeBreak();
    
    /**
     * Return makeBeforeBreak, guaranteed to be non-null.
     *
     * @return {@code Boolean} makeBeforeBreak, guaranteed to be non-null.
     * @throws NoSuchElementException if makeBeforeBreak is not present
     *
     */
    default @NonNull Boolean requireMakeBeforeBreak() {
        return CodeHelpers.require(getMakeBeforeBreak(), "makebeforebreak");
    }

}

