package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.RequestId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.rp.Tlvs;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link RpBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     RpBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new RpBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of RpBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see RpBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class RpBuilder implements Builder<Rp> {

    private Boolean _biDirectional;
    private Boolean _eroCompression;
    private Boolean _fragmentation;
    private Boolean _ignore;
    private Boolean _loose;
    private Boolean _makeBeforeBreak;
    private Boolean _order;
    private Boolean _p2mp;
    private Boolean _pathKey;
    private Uint8 _priority;
    private Boolean _processingRule;
    private Boolean _reoptimization;
    private RequestId _requestId;
    private Boolean _supplyOf;
    private Tlvs _tlvs;


    Map<Class<? extends Augmentation<Rp>>, Augmentation<Rp>> augmentation = Collections.emptyMap();

    public RpBuilder() {
    }
    
    
    
    public RpBuilder(Object arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }
    public RpBuilder(ObjectHeader arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public RpBuilder(Rp base) {
        Map<Class<? extends Augmentation<Rp>>, Augmentation<Rp>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._biDirectional = base.getBiDirectional();
        this._eroCompression = base.getEroCompression();
        this._fragmentation = base.getFragmentation();
        this._ignore = base.getIgnore();
        this._loose = base.getLoose();
        this._makeBeforeBreak = base.getMakeBeforeBreak();
        this._order = base.getOrder();
        this._p2mp = base.getP2mp();
        this._pathKey = base.getPathKey();
        this._priority = base.getPriority();
        this._processingRule = base.getProcessingRule();
        this._reoptimization = base.getReoptimization();
        this._requestId = base.getRequestId();
        this._supplyOf = base.getSupplyOf();
        this._tlvs = base.getTlvs();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>ObjectHeader</li>
     * <li>Object</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).getProcessingRule();
            this._ignore = ((ObjectHeader)arg).getIgnore();
            isValidArg = true;
        }
        if (arg instanceof Object) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[ObjectHeader, Object]");
    }

    public Boolean getBiDirectional() {
        return _biDirectional;
    }
    
    public Boolean getEroCompression() {
        return _eroCompression;
    }
    
    public Boolean getFragmentation() {
        return _fragmentation;
    }
    
    public Boolean getIgnore() {
        return _ignore;
    }
    
    public Boolean getLoose() {
        return _loose;
    }
    
    public Boolean getMakeBeforeBreak() {
        return _makeBeforeBreak;
    }
    
    public Boolean getOrder() {
        return _order;
    }
    
    public Boolean getP2mp() {
        return _p2mp;
    }
    
    public Boolean getPathKey() {
        return _pathKey;
    }
    
    public Uint8 getPriority() {
        return _priority;
    }
    
    public Boolean getProcessingRule() {
        return _processingRule;
    }
    
    public Boolean getReoptimization() {
        return _reoptimization;
    }
    
    public RequestId getRequestId() {
        return _requestId;
    }
    
    public Boolean getSupplyOf() {
        return _supplyOf;
    }
    
    public Tlvs getTlvs() {
        return _tlvs;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Rp>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public RpBuilder setBiDirectional(final Boolean value) {
        this._biDirectional = value;
        return this;
    }
    
    public RpBuilder setEroCompression(final Boolean value) {
        this._eroCompression = value;
        return this;
    }
    
    public RpBuilder setFragmentation(final Boolean value) {
        this._fragmentation = value;
        return this;
    }
    
    public RpBuilder setIgnore(final Boolean value) {
        this._ignore = value;
        return this;
    }
    
    public RpBuilder setLoose(final Boolean value) {
        this._loose = value;
        return this;
    }
    
    public RpBuilder setMakeBeforeBreak(final Boolean value) {
        this._makeBeforeBreak = value;
        return this;
    }
    
    public RpBuilder setOrder(final Boolean value) {
        this._order = value;
        return this;
    }
    
    public RpBuilder setP2mp(final Boolean value) {
        this._p2mp = value;
        return this;
    }
    
    public RpBuilder setPathKey(final Boolean value) {
        this._pathKey = value;
        return this;
    }
    
    private static void checkPriorityRange(final short value) {
        if (value >= (short)1 && value <= (short)7) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[1..7]]", value);
    }
    
    public RpBuilder setPriority(final Uint8 value) {
        if (value != null) {
            checkPriorityRange(value.shortValue());
            
        }
        this._priority = value;
        return this;
    }
    
    public RpBuilder setProcessingRule(final Boolean value) {
        this._processingRule = value;
        return this;
    }
    
    public RpBuilder setReoptimization(final Boolean value) {
        this._reoptimization = value;
        return this;
    }
    
    public RpBuilder setRequestId(final RequestId value) {
        this._requestId = value;
        return this;
    }
    
    public RpBuilder setSupplyOf(final Boolean value) {
        this._supplyOf = value;
        return this;
    }
    
    public RpBuilder setTlvs(final Tlvs value) {
        this._tlvs = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public RpBuilder addAugmentation(Augmentation<Rp> augmentation) {
        Class<? extends Augmentation<Rp>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public RpBuilder removeAugmentation(Class<? extends Augmentation<Rp>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Rp build() {
        return new RpImpl(this);
    }

    private static final class RpImpl
        extends AbstractAugmentable<Rp>
        implements Rp {
    
        private final Boolean _biDirectional;
        private final Boolean _eroCompression;
        private final Boolean _fragmentation;
        private final Boolean _ignore;
        private final Boolean _loose;
        private final Boolean _makeBeforeBreak;
        private final Boolean _order;
        private final Boolean _p2mp;
        private final Boolean _pathKey;
        private final Uint8 _priority;
        private final Boolean _processingRule;
        private final Boolean _reoptimization;
        private final RequestId _requestId;
        private final Boolean _supplyOf;
        private final Tlvs _tlvs;
    
        RpImpl(RpBuilder base) {
            super(base.augmentation);
            this._biDirectional = base.getBiDirectional();
            this._eroCompression = base.getEroCompression();
            this._fragmentation = base.getFragmentation();
            this._ignore = base.getIgnore();
            this._loose = base.getLoose();
            this._makeBeforeBreak = base.getMakeBeforeBreak();
            this._order = base.getOrder();
            this._p2mp = base.getP2mp();
            this._pathKey = base.getPathKey();
            this._priority = base.getPriority();
            this._processingRule = base.getProcessingRule();
            this._reoptimization = base.getReoptimization();
            this._requestId = base.getRequestId();
            this._supplyOf = base.getSupplyOf();
            this._tlvs = base.getTlvs();
        }
    
        @Override
        public Boolean getBiDirectional() {
            return _biDirectional;
        }
        
        @Override
        public Boolean getEroCompression() {
            return _eroCompression;
        }
        
        @Override
        public Boolean getFragmentation() {
            return _fragmentation;
        }
        
        @Override
        public Boolean getIgnore() {
            return _ignore;
        }
        
        @Override
        public Boolean getLoose() {
            return _loose;
        }
        
        @Override
        public Boolean getMakeBeforeBreak() {
            return _makeBeforeBreak;
        }
        
        @Override
        public Boolean getOrder() {
            return _order;
        }
        
        @Override
        public Boolean getP2mp() {
            return _p2mp;
        }
        
        @Override
        public Boolean getPathKey() {
            return _pathKey;
        }
        
        @Override
        public Uint8 getPriority() {
            return _priority;
        }
        
        @Override
        public Boolean getProcessingRule() {
            return _processingRule;
        }
        
        @Override
        public Boolean getReoptimization() {
            return _reoptimization;
        }
        
        @Override
        public RequestId getRequestId() {
            return _requestId;
        }
        
        @Override
        public Boolean getSupplyOf() {
            return _supplyOf;
        }
        
        @Override
        public Tlvs getTlvs() {
            return _tlvs;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Rp.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(java.lang.Object obj) {
            return Rp.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Rp.bindingToString(this);
        }
    }
}
