package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.secondary.reported.route.object.srro;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.RecordRouteSubobjects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.SecondaryRecordRouteSubobjects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.SubobjectType;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SubobjectBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     SubobjectBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new SubobjectBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of SubobjectBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see SubobjectBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class SubobjectBuilder implements Builder<Subobject> {

    private Boolean _protectionAvailable;
    private Boolean _protectionInUse;
    private SubobjectType _subobjectType;


    Map<Class<? extends Augmentation<Subobject>>, Augmentation<Subobject>> augmentation = Collections.emptyMap();

    public SubobjectBuilder() {
    }
    
    
    
    public SubobjectBuilder(SecondaryRecordRouteSubobjects arg) {
        this._protectionAvailable = arg.getProtectionAvailable();
        this._protectionInUse = arg.getProtectionInUse();
        this._subobjectType = arg.getSubobjectType();
    }
    public SubobjectBuilder(RecordRouteSubobjects arg) {
        this._protectionAvailable = arg.getProtectionAvailable();
        this._protectionInUse = arg.getProtectionInUse();
        this._subobjectType = arg.getSubobjectType();
    }

    public SubobjectBuilder(Subobject base) {
        Map<Class<? extends Augmentation<Subobject>>, Augmentation<Subobject>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._protectionAvailable = base.getProtectionAvailable();
        this._protectionInUse = base.getProtectionInUse();
        this._subobjectType = base.getSubobjectType();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>RecordRouteSubobjects</li>
     * <li>SecondaryRecordRouteSubobjects</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof RecordRouteSubobjects) {
            this._protectionAvailable = ((RecordRouteSubobjects)arg).getProtectionAvailable();
            this._protectionInUse = ((RecordRouteSubobjects)arg).getProtectionInUse();
            this._subobjectType = ((RecordRouteSubobjects)arg).getSubobjectType();
            isValidArg = true;
        }
        if (arg instanceof SecondaryRecordRouteSubobjects) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[RecordRouteSubobjects, SecondaryRecordRouteSubobjects]");
    }

    public Boolean getProtectionAvailable() {
        return _protectionAvailable;
    }
    
    public Boolean getProtectionInUse() {
        return _protectionInUse;
    }
    
    public SubobjectType getSubobjectType() {
        return _subobjectType;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Subobject>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public SubobjectBuilder setProtectionAvailable(final Boolean value) {
        this._protectionAvailable = value;
        return this;
    }
    
    public SubobjectBuilder setProtectionInUse(final Boolean value) {
        this._protectionInUse = value;
        return this;
    }
    
    public SubobjectBuilder setSubobjectType(final SubobjectType value) {
        this._subobjectType = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public SubobjectBuilder addAugmentation(Augmentation<Subobject> augmentation) {
        Class<? extends Augmentation<Subobject>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public SubobjectBuilder removeAugmentation(Class<? extends Augmentation<Subobject>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Subobject build() {
        return new SubobjectImpl(this);
    }

    private static final class SubobjectImpl
        extends AbstractAugmentable<Subobject>
        implements Subobject {
    
        private final Boolean _protectionAvailable;
        private final Boolean _protectionInUse;
        private final SubobjectType _subobjectType;
    
        SubobjectImpl(SubobjectBuilder base) {
            super(base.augmentation);
            this._protectionAvailable = base.getProtectionAvailable();
            this._protectionInUse = base.getProtectionInUse();
            this._subobjectType = base.getSubobjectType();
        }
    
        @Override
        public Boolean getProtectionAvailable() {
            return _protectionAvailable;
        }
        
        @Override
        public Boolean getProtectionInUse() {
            return _protectionInUse;
        }
        
        @Override
        public SubobjectType getSubobjectType() {
            return _subobjectType;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Subobject.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Subobject.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Subobject.bindingToString(this);
        }
    }
}
