package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.svec.object;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.RequestId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.SvecObject;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container svec {
 *   uses object;
 *   leaf link-diverse {
 *     type boolean;
 *     default false;
 *   }
 *   leaf node-diverse {
 *     type boolean;
 *     default false;
 *   }
 *   leaf srlg-diverse {
 *     type boolean;
 *     default false;
 *   }
 *   leaf partial-path-diverse {
 *     type boolean;
 *     default false;
 *   }
 *   leaf link-direction-diverse {
 *     type boolean;
 *     default false;
 *   }
 *   leaf-list requests-ids {
 *     type request-id;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typessvec-objectsvec</i>
 *
 * <p>To create instances of this class use {@link SvecBuilder}.
 * @see SvecBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Svec
    extends
    ChildOf<SvecObject>,
    Augmentable<Svec>,
    Object
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("svec");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.svec.object.Svec> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.svec.object.Svec.class;
    }
    
    /**
     * Default implementation of {@link java.lang.Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.svec.object.@NonNull Svec obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getIgnore());
        result = prime * result + Objects.hashCode(obj.getLinkDirectionDiverse());
        result = prime * result + Objects.hashCode(obj.getLinkDiverse());
        result = prime * result + Objects.hashCode(obj.getNodeDiverse());
        result = prime * result + Objects.hashCode(obj.getPartialPathDiverse());
        result = prime * result + Objects.hashCode(obj.getProcessingRule());
        result = prime * result + Objects.hashCode(obj.getRequestsIds());
        result = prime * result + Objects.hashCode(obj.getSrlgDiverse());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link java.lang.Object#equals(java.lang.Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.svec.object.@NonNull Svec thisObj, final java.lang.Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.svec.object.Svec other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.svec.object.Svec.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getIgnore(), other.getIgnore())) {
            return false;
        }
        if (!Objects.equals(thisObj.getLinkDirectionDiverse(), other.getLinkDirectionDiverse())) {
            return false;
        }
        if (!Objects.equals(thisObj.getLinkDiverse(), other.getLinkDiverse())) {
            return false;
        }
        if (!Objects.equals(thisObj.getNodeDiverse(), other.getNodeDiverse())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPartialPathDiverse(), other.getPartialPathDiverse())) {
            return false;
        }
        if (!Objects.equals(thisObj.getProcessingRule(), other.getProcessingRule())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSrlgDiverse(), other.getSrlgDiverse())) {
            return false;
        }
        if (!Objects.equals(thisObj.getRequestsIds(), other.getRequestsIds())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link java.lang.Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.svec.object.@NonNull Svec obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Svec");
        CodeHelpers.appendValue(helper, "ignore", obj.getIgnore());
        CodeHelpers.appendValue(helper, "linkDirectionDiverse", obj.getLinkDirectionDiverse());
        CodeHelpers.appendValue(helper, "linkDiverse", obj.getLinkDiverse());
        CodeHelpers.appendValue(helper, "nodeDiverse", obj.getNodeDiverse());
        CodeHelpers.appendValue(helper, "partialPathDiverse", obj.getPartialPathDiverse());
        CodeHelpers.appendValue(helper, "processingRule", obj.getProcessingRule());
        CodeHelpers.appendValue(helper, "requestsIds", obj.getRequestsIds());
        CodeHelpers.appendValue(helper, "srlgDiverse", obj.getSrlgDiverse());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return linkDiverse, or {@code null} if it is not present.
     *
     * @return {@code Boolean} linkDiverse, or {@code null} if it is not present.
     *
     */
    Boolean getLinkDiverse();
    
    /**
     * Return linkDiverse, guaranteed to be non-null.
     *
     * @return {@code Boolean} linkDiverse, guaranteed to be non-null.
     * @throws NoSuchElementException if linkDiverse is not present
     *
     */
    default @NonNull Boolean requireLinkDiverse() {
        return CodeHelpers.require(getLinkDiverse(), "linkdiverse");
    }
    
    /**
     * Return nodeDiverse, or {@code null} if it is not present.
     *
     * @return {@code Boolean} nodeDiverse, or {@code null} if it is not present.
     *
     */
    Boolean getNodeDiverse();
    
    /**
     * Return nodeDiverse, guaranteed to be non-null.
     *
     * @return {@code Boolean} nodeDiverse, guaranteed to be non-null.
     * @throws NoSuchElementException if nodeDiverse is not present
     *
     */
    default @NonNull Boolean requireNodeDiverse() {
        return CodeHelpers.require(getNodeDiverse(), "nodediverse");
    }
    
    /**
     * Return srlgDiverse, or {@code null} if it is not present.
     *
     * @return {@code Boolean} srlgDiverse, or {@code null} if it is not present.
     *
     */
    Boolean getSrlgDiverse();
    
    /**
     * Return srlgDiverse, guaranteed to be non-null.
     *
     * @return {@code Boolean} srlgDiverse, guaranteed to be non-null.
     * @throws NoSuchElementException if srlgDiverse is not present
     *
     */
    default @NonNull Boolean requireSrlgDiverse() {
        return CodeHelpers.require(getSrlgDiverse(), "srlgdiverse");
    }
    
    /**
     * Return partialPathDiverse, or {@code null} if it is not present.
     *
     * @return {@code Boolean} partialPathDiverse, or {@code null} if it is not present.
     *
     */
    Boolean getPartialPathDiverse();
    
    /**
     * Return partialPathDiverse, guaranteed to be non-null.
     *
     * @return {@code Boolean} partialPathDiverse, guaranteed to be non-null.
     * @throws NoSuchElementException if partialPathDiverse is not present
     *
     */
    default @NonNull Boolean requirePartialPathDiverse() {
        return CodeHelpers.require(getPartialPathDiverse(), "partialpathdiverse");
    }
    
    /**
     * Return linkDirectionDiverse, or {@code null} if it is not present.
     *
     * @return {@code Boolean} linkDirectionDiverse, or {@code null} if it is not present.
     *
     */
    Boolean getLinkDirectionDiverse();
    
    /**
     * Return linkDirectionDiverse, guaranteed to be non-null.
     *
     * @return {@code Boolean} linkDirectionDiverse, guaranteed to be non-null.
     * @throws NoSuchElementException if linkDirectionDiverse is not present
     *
     */
    default @NonNull Boolean requireLinkDirectionDiverse() {
        return CodeHelpers.require(getLinkDirectionDiverse(), "linkdirectiondiverse");
    }
    
    /**
     * Return requestsIds, or {@code null} if it is not present.
     *
     * @return {@code List<RequestId>} requestsIds, or {@code null} if it is not present.
     *
     */
    @Nullable List<RequestId> getRequestsIds();
    
    /**
     * Return requestsIds, guaranteed to be non-null.
     *
     * @return {@code List<RequestId>} requestsIds, guaranteed to be non-null.
     * @throws NoSuchElementException if requestsIds is not present
     *
     */
    default @NonNull List<RequestId> requireRequestsIds() {
        return CodeHelpers.require(getRequestsIds(), "requestsids");
    }

}

