package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.svec.object;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.RequestId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SvecBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     SvecBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new SvecBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of SvecBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see SvecBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class SvecBuilder implements Builder<Svec> {

    private Boolean _ignore;
    private Boolean _linkDirectionDiverse;
    private Boolean _linkDiverse;
    private Boolean _nodeDiverse;
    private Boolean _partialPathDiverse;
    private Boolean _processingRule;
    private List<RequestId> _requestsIds;
    private Boolean _srlgDiverse;


    Map<Class<? extends Augmentation<Svec>>, Augmentation<Svec>> augmentation = Collections.emptyMap();

    public SvecBuilder() {
    }
    
    
    
    public SvecBuilder(Object arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }
    public SvecBuilder(ObjectHeader arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public SvecBuilder(Svec base) {
        Map<Class<? extends Augmentation<Svec>>, Augmentation<Svec>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._ignore = base.getIgnore();
        this._linkDirectionDiverse = base.getLinkDirectionDiverse();
        this._linkDiverse = base.getLinkDiverse();
        this._nodeDiverse = base.getNodeDiverse();
        this._partialPathDiverse = base.getPartialPathDiverse();
        this._processingRule = base.getProcessingRule();
        this._requestsIds = base.getRequestsIds();
        this._srlgDiverse = base.getSrlgDiverse();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>ObjectHeader</li>
     * <li>Object</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).getProcessingRule();
            this._ignore = ((ObjectHeader)arg).getIgnore();
            isValidArg = true;
        }
        if (arg instanceof Object) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[ObjectHeader, Object]");
    }

    public Boolean getIgnore() {
        return _ignore;
    }
    
    public Boolean getLinkDirectionDiverse() {
        return _linkDirectionDiverse;
    }
    
    public Boolean getLinkDiverse() {
        return _linkDiverse;
    }
    
    public Boolean getNodeDiverse() {
        return _nodeDiverse;
    }
    
    public Boolean getPartialPathDiverse() {
        return _partialPathDiverse;
    }
    
    public Boolean getProcessingRule() {
        return _processingRule;
    }
    
    public List<RequestId> getRequestsIds() {
        return _requestsIds;
    }
    
    public Boolean getSrlgDiverse() {
        return _srlgDiverse;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Svec>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public SvecBuilder setIgnore(final Boolean value) {
        this._ignore = value;
        return this;
    }
    
    public SvecBuilder setLinkDirectionDiverse(final Boolean value) {
        this._linkDirectionDiverse = value;
        return this;
    }
    
    public SvecBuilder setLinkDiverse(final Boolean value) {
        this._linkDiverse = value;
        return this;
    }
    
    public SvecBuilder setNodeDiverse(final Boolean value) {
        this._nodeDiverse = value;
        return this;
    }
    
    public SvecBuilder setPartialPathDiverse(final Boolean value) {
        this._partialPathDiverse = value;
        return this;
    }
    
    public SvecBuilder setProcessingRule(final Boolean value) {
        this._processingRule = value;
        return this;
    }
    public SvecBuilder setRequestsIds(final List<RequestId> values) {
        this._requestsIds = values;
        return this;
    }
    
    
    public SvecBuilder setSrlgDiverse(final Boolean value) {
        this._srlgDiverse = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public SvecBuilder addAugmentation(Augmentation<Svec> augmentation) {
        Class<? extends Augmentation<Svec>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public SvecBuilder removeAugmentation(Class<? extends Augmentation<Svec>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Svec build() {
        return new SvecImpl(this);
    }

    private static final class SvecImpl
        extends AbstractAugmentable<Svec>
        implements Svec {
    
        private final Boolean _ignore;
        private final Boolean _linkDirectionDiverse;
        private final Boolean _linkDiverse;
        private final Boolean _nodeDiverse;
        private final Boolean _partialPathDiverse;
        private final Boolean _processingRule;
        private final List<RequestId> _requestsIds;
        private final Boolean _srlgDiverse;
    
        SvecImpl(SvecBuilder base) {
            super(base.augmentation);
            this._ignore = base.getIgnore();
            this._linkDirectionDiverse = base.getLinkDirectionDiverse();
            this._linkDiverse = base.getLinkDiverse();
            this._nodeDiverse = base.getNodeDiverse();
            this._partialPathDiverse = base.getPartialPathDiverse();
            this._processingRule = base.getProcessingRule();
            this._requestsIds = base.getRequestsIds();
            this._srlgDiverse = base.getSrlgDiverse();
        }
    
        @Override
        public Boolean getIgnore() {
            return _ignore;
        }
        
        @Override
        public Boolean getLinkDirectionDiverse() {
            return _linkDirectionDiverse;
        }
        
        @Override
        public Boolean getLinkDiverse() {
            return _linkDiverse;
        }
        
        @Override
        public Boolean getNodeDiverse() {
            return _nodeDiverse;
        }
        
        @Override
        public Boolean getPartialPathDiverse() {
            return _partialPathDiverse;
        }
        
        @Override
        public Boolean getProcessingRule() {
            return _processingRule;
        }
        
        @Override
        public List<RequestId> getRequestsIds() {
            return _requestsIds;
        }
        
        @Override
        public Boolean getSrlgDiverse() {
            return _srlgDiverse;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Svec.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(java.lang.Object obj) {
            return Svec.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Svec.bindingToString(this);
        }
    }
}
