package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.UnreachDestinationObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.unreach.destination.obj.Destination;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container unreach-destination-obj {
 *   uses object;
 *   choice destination {
 *     case ipv4-destination-case {
 *       uses ipv4-destinations;
 *     }
 *     case ipv6-destination-case {
 *       uses ipv6-destinations;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typesunreach-destination-objectunreach-destination-obj</i>
 *
 * <p>To create instances of this class use {@link UnreachDestinationObjBuilder}.
 * @see UnreachDestinationObjBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface UnreachDestinationObj
    extends
    ChildOf<UnreachDestinationObject>,
    Augmentable<UnreachDestinationObj>,
    Object
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("unreach-destination-obj");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.UnreachDestinationObj> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.UnreachDestinationObj.class;
    }
    
    /**
     * Default implementation of {@link java.lang.Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.@NonNull UnreachDestinationObj obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getDestination());
        result = prime * result + Objects.hashCode(obj.getIgnore());
        result = prime * result + Objects.hashCode(obj.getProcessingRule());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link java.lang.Object#equals(java.lang.Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.@NonNull UnreachDestinationObj thisObj, final java.lang.Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.UnreachDestinationObj other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.UnreachDestinationObj.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getIgnore(), other.getIgnore())) {
            return false;
        }
        if (!Objects.equals(thisObj.getProcessingRule(), other.getProcessingRule())) {
            return false;
        }
        if (!Objects.equals(thisObj.getDestination(), other.getDestination())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link java.lang.Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.@NonNull UnreachDestinationObj obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("UnreachDestinationObj");
        CodeHelpers.appendValue(helper, "destination", obj.getDestination());
        CodeHelpers.appendValue(helper, "ignore", obj.getIgnore());
        CodeHelpers.appendValue(helper, "processingRule", obj.getProcessingRule());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return destination, or {@code null} if it is not present.
     *
     * @return {@code Destination} destination, or {@code null} if it is not present.
     *
     */
    Destination getDestination();

}

