package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.unreach.destination.obj.destination;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Ipv6Destinations;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Ipv6DestinationCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Ipv6DestinationCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new Ipv6DestinationCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Ipv6DestinationCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Ipv6DestinationCaseBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class Ipv6DestinationCaseBuilder implements Builder<Ipv6DestinationCase> {

    private List<Ipv6AddressNoZone> _destinationIpv6Address;


    Map<Class<? extends Augmentation<Ipv6DestinationCase>>, Augmentation<Ipv6DestinationCase>> augmentation = Collections.emptyMap();

    public Ipv6DestinationCaseBuilder() {
    }
    
    
    
    
    public Ipv6DestinationCaseBuilder(Ipv6Destinations arg) {
        this._destinationIpv6Address = arg.getDestinationIpv6Address();
    }

    public Ipv6DestinationCaseBuilder(Ipv6DestinationCase base) {
        Map<Class<? extends Augmentation<Ipv6DestinationCase>>, Augmentation<Ipv6DestinationCase>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._destinationIpv6Address = base.getDestinationIpv6Address();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>Ipv6Destinations</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Ipv6Destinations) {
            this._destinationIpv6Address = ((Ipv6Destinations)arg).getDestinationIpv6Address();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[Ipv6Destinations]");
    }

    public List<Ipv6AddressNoZone> getDestinationIpv6Address() {
        return _destinationIpv6Address;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Ipv6DestinationCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public Ipv6DestinationCaseBuilder setDestinationIpv6Address(final List<Ipv6AddressNoZone> values) {
        this._destinationIpv6Address = values;
        return this;
    }
    
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public Ipv6DestinationCaseBuilder addAugmentation(Augmentation<Ipv6DestinationCase> augmentation) {
        Class<? extends Augmentation<Ipv6DestinationCase>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public Ipv6DestinationCaseBuilder removeAugmentation(Class<? extends Augmentation<Ipv6DestinationCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Ipv6DestinationCase build() {
        return new Ipv6DestinationCaseImpl(this);
    }

    private static final class Ipv6DestinationCaseImpl
        extends AbstractAugmentable<Ipv6DestinationCase>
        implements Ipv6DestinationCase {
    
        private final List<Ipv6AddressNoZone> _destinationIpv6Address;
    
        Ipv6DestinationCaseImpl(Ipv6DestinationCaseBuilder base) {
            super(base.augmentation);
            this._destinationIpv6Address = base.getDestinationIpv6Address();
        }
    
        @Override
        public List<Ipv6AddressNoZone> getDestinationIpv6Address() {
            return _destinationIpv6Address;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Ipv6DestinationCase.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Ipv6DestinationCase.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Ipv6DestinationCase.bindingToString(this);
        }
    }
}
