package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.objects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.iana.rev130816.EnterpriseNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.VendorInformation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.EnterpriseSpecificInformation;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link VendorInformationObjectBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     VendorInformationObjectBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new VendorInformationObjectBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of VendorInformationObjectBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see VendorInformationObjectBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class VendorInformationObjectBuilder implements Builder<VendorInformationObject> {

    private EnterpriseNumber _enterpriseNumber;
    private EnterpriseSpecificInformation _enterpriseSpecificInformation;
    private Boolean _ignore;
    private Boolean _processingRule;


    Map<Class<? extends Augmentation<VendorInformationObject>>, Augmentation<VendorInformationObject>> augmentation = Collections.emptyMap();

    public VendorInformationObjectBuilder() {
    }
    
    
    
    public VendorInformationObjectBuilder(Object arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }
    public VendorInformationObjectBuilder(ObjectHeader arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }
    
    public VendorInformationObjectBuilder(VendorInformation arg) {
        this._enterpriseNumber = arg.getEnterpriseNumber();
        this._enterpriseSpecificInformation = arg.getEnterpriseSpecificInformation();
    }

    public VendorInformationObjectBuilder(VendorInformationObject base) {
        Map<Class<? extends Augmentation<VendorInformationObject>>, Augmentation<VendorInformationObject>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._enterpriseNumber = base.getEnterpriseNumber();
        this._enterpriseSpecificInformation = base.getEnterpriseSpecificInformation();
        this._ignore = base.getIgnore();
        this._processingRule = base.getProcessingRule();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>VendorInformation</li>
     * <li>ObjectHeader</li>
     * <li>Object</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof VendorInformation) {
            this._enterpriseNumber = ((VendorInformation)arg).getEnterpriseNumber();
            this._enterpriseSpecificInformation = ((VendorInformation)arg).getEnterpriseSpecificInformation();
            isValidArg = true;
        }
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).getProcessingRule();
            this._ignore = ((ObjectHeader)arg).getIgnore();
            isValidArg = true;
        }
        if (arg instanceof Object) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[VendorInformation, ObjectHeader, Object]");
    }

    public EnterpriseNumber getEnterpriseNumber() {
        return _enterpriseNumber;
    }
    
    public EnterpriseSpecificInformation getEnterpriseSpecificInformation() {
        return _enterpriseSpecificInformation;
    }
    
    public Boolean getIgnore() {
        return _ignore;
    }
    
    public Boolean getProcessingRule() {
        return _processingRule;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<VendorInformationObject>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public VendorInformationObjectBuilder setEnterpriseNumber(final EnterpriseNumber value) {
        this._enterpriseNumber = value;
        return this;
    }
    
    public VendorInformationObjectBuilder setEnterpriseSpecificInformation(final EnterpriseSpecificInformation value) {
        this._enterpriseSpecificInformation = value;
        return this;
    }
    
    public VendorInformationObjectBuilder setIgnore(final Boolean value) {
        this._ignore = value;
        return this;
    }
    
    public VendorInformationObjectBuilder setProcessingRule(final Boolean value) {
        this._processingRule = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public VendorInformationObjectBuilder addAugmentation(Augmentation<VendorInformationObject> augmentation) {
        Class<? extends Augmentation<VendorInformationObject>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public VendorInformationObjectBuilder removeAugmentation(Class<? extends Augmentation<VendorInformationObject>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public VendorInformationObject build() {
        return new VendorInformationObjectImpl(this);
    }

    private static final class VendorInformationObjectImpl
        extends AbstractAugmentable<VendorInformationObject>
        implements VendorInformationObject {
    
        private final EnterpriseNumber _enterpriseNumber;
        private final EnterpriseSpecificInformation _enterpriseSpecificInformation;
        private final Boolean _ignore;
        private final Boolean _processingRule;
    
        VendorInformationObjectImpl(VendorInformationObjectBuilder base) {
            super(base.augmentation);
            this._enterpriseNumber = base.getEnterpriseNumber();
            this._enterpriseSpecificInformation = base.getEnterpriseSpecificInformation();
            this._ignore = base.getIgnore();
            this._processingRule = base.getProcessingRule();
        }
    
        @Override
        public EnterpriseNumber getEnterpriseNumber() {
            return _enterpriseNumber;
        }
        
        @Override
        public EnterpriseSpecificInformation getEnterpriseSpecificInformation() {
            return _enterpriseSpecificInformation;
        }
        
        @Override
        public Boolean getIgnore() {
            return _ignore;
        }
        
        @Override
        public Boolean getProcessingRule() {
            return _processingRule;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = VendorInformationObject.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(java.lang.Object obj) {
            return VendorInformationObject.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return VendorInformationObject.bindingToString(this);
        }
    }
}
