package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.tlvs;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.iana.rev130816.EnterpriseNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.VendorInformation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.EnterpriseSpecificInformation;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link VendorInformationTlvBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     VendorInformationTlvBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new VendorInformationTlvBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of VendorInformationTlvBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see VendorInformationTlvBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class VendorInformationTlvBuilder implements Builder<VendorInformationTlv> {

    private EnterpriseNumber _enterpriseNumber;
    private EnterpriseSpecificInformation _enterpriseSpecificInformation;


    Map<Class<? extends Augmentation<VendorInformationTlv>>, Augmentation<VendorInformationTlv>> augmentation = Collections.emptyMap();

    public VendorInformationTlvBuilder() {
    }
    
    
    
    public VendorInformationTlvBuilder(Tlv arg) {
    }
    
    public VendorInformationTlvBuilder(VendorInformation arg) {
        this._enterpriseNumber = arg.getEnterpriseNumber();
        this._enterpriseSpecificInformation = arg.getEnterpriseSpecificInformation();
    }

    public VendorInformationTlvBuilder(VendorInformationTlv base) {
        Map<Class<? extends Augmentation<VendorInformationTlv>>, Augmentation<VendorInformationTlv>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._enterpriseNumber = base.getEnterpriseNumber();
        this._enterpriseSpecificInformation = base.getEnterpriseSpecificInformation();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>Tlv</li>
     * <li>VendorInformation</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Tlv) {
            isValidArg = true;
        }
        if (arg instanceof VendorInformation) {
            this._enterpriseNumber = ((VendorInformation)arg).getEnterpriseNumber();
            this._enterpriseSpecificInformation = ((VendorInformation)arg).getEnterpriseSpecificInformation();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[Tlv, VendorInformation]");
    }

    public EnterpriseNumber getEnterpriseNumber() {
        return _enterpriseNumber;
    }
    
    public EnterpriseSpecificInformation getEnterpriseSpecificInformation() {
        return _enterpriseSpecificInformation;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<VendorInformationTlv>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public VendorInformationTlvBuilder setEnterpriseNumber(final EnterpriseNumber value) {
        this._enterpriseNumber = value;
        return this;
    }
    
    public VendorInformationTlvBuilder setEnterpriseSpecificInformation(final EnterpriseSpecificInformation value) {
        this._enterpriseSpecificInformation = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public VendorInformationTlvBuilder addAugmentation(Augmentation<VendorInformationTlv> augmentation) {
        Class<? extends Augmentation<VendorInformationTlv>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public VendorInformationTlvBuilder removeAugmentation(Class<? extends Augmentation<VendorInformationTlv>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public VendorInformationTlv build() {
        return new VendorInformationTlvImpl(this);
    }

    private static final class VendorInformationTlvImpl
        extends AbstractAugmentable<VendorInformationTlv>
        implements VendorInformationTlv {
    
        private final EnterpriseNumber _enterpriseNumber;
        private final EnterpriseSpecificInformation _enterpriseSpecificInformation;
    
        VendorInformationTlvImpl(VendorInformationTlvBuilder base) {
            super(base.augmentation);
            this._enterpriseNumber = base.getEnterpriseNumber();
            this._enterpriseSpecificInformation = base.getEnterpriseSpecificInformation();
        }
    
        @Override
        public EnterpriseNumber getEnterpriseNumber() {
            return _enterpriseNumber;
        }
        
        @Override
        public EnterpriseSpecificInformation getEnterpriseSpecificInformation() {
            return _enterpriseSpecificInformation;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = VendorInformationTlv.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return VendorInformationTlv.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return VendorInformationTlv.bindingToString(this);
        }
    }
}
