/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep;

import com.google.common.base.Verify;
import java.util.Arrays;
import org.opendaylight.yangtools.yang.common.Uint8;

public enum TerminationReason {
    UNKNOWN(1),
    EXP_DEADTIMER(2),
    MALFORMED_MSG(3),
    TOO_MANY_UNKNWN_REQS(4),
    TOO_MANY_UNKNOWN_MSGS(5);

    private static final TerminationReason[] REASONS;
    private final Uint8 value;

    private TerminationReason(int value) {
        this.value = Uint8.valueOf((int)value);
    }

    public Uint8 getUintValue() {
        return this.value;
    }

    public static TerminationReason forValue(Uint8 valueArg) {
        short value = valueArg.toJava();
        return value >= REASONS.length ? null : REASONS[value];
    }

    static {
        TerminationReason[] reasons = TerminationReason.values();
        Verify.verify((reasons.length > 0 ? 1 : 0) != 0);
        short highest = Arrays.stream(reasons).map(TerminationReason::getUintValue).max(Uint8::compareTo).orElseThrow().toJava();
        TerminationReason[] init = new TerminationReason[highest + 1];
        TerminationReason[] terminationReasonArray = reasons;
        int n = terminationReasonArray.length;
        for (int i = 0; i < n; ++i) {
            TerminationReason reason;
            init[reason.getUintValue().toJava()] = reason = terminationReasonArray[i];
        }
        REASONS = init;
    }
}

