/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;
import org.opendaylight.yangtools.yang.common.Uint8;

public class ClassType
implements ScalarTypeObject<Uint8>,
Serializable {
    private static final long serialVersionUID = 7216175713280286513L;
    private final Uint8 _value;

    private static void check_valueRange(short value) {
        if (value >= 1 && value <= 7) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[1..7]]", (int)value);
    }

    @ConstructorParameters(value={"value"})
    public ClassType(Uint8 _value) {
        if (_value != null) {
            ClassType.check_valueRange(_value.shortValue());
        }
        CodeHelpers.requireValue((Object)_value);
        this._value = _value;
    }

    public ClassType(ClassType source) {
        this._value = source._value;
    }

    public static ClassType getDefaultInstance(String defaultValue) {
        return new ClassType(Uint8.valueOf((String)defaultValue));
    }

    public Uint8 getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof ClassType)) return false;
        ClassType other = (ClassType)obj;
        if (!Objects.equals(this._value, other._value)) return false;
        return true;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(ClassType.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"value", (Object)this._value);
        return helper.toString();
    }
}

