/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.branch.node.object;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Bnc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bnc.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.branch.node.object.BranchNodeList;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class BranchNodeListBuilder {
    private Boolean _ignore;
    private Boolean _processingRule;
    private List<Subobject> _subobject;
    Map<Class<? extends Augmentation<BranchNodeList>>, Augmentation<BranchNodeList>> augmentation = Map.of();

    public BranchNodeListBuilder() {
    }

    public BranchNodeListBuilder(Bnc arg) {
        this._subobject = arg.getSubobject();
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public BranchNodeListBuilder(Object arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public BranchNodeListBuilder(ObjectHeader arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public BranchNodeListBuilder(BranchNodeList base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BranchNodeList>>, Augmentation<BranchNodeList>>(aug);
        }
        this._ignore = base.getIgnore();
        this._processingRule = base.getProcessingRule();
        this._subobject = base.getSubobject();
    }

    public void fieldsFrom(DataObject arg) {
        ObjectHeader castArg;
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            castArg = (ObjectHeader)arg;
            this._processingRule = castArg.getProcessingRule();
            this._ignore = castArg.getIgnore();
            isValidArg = true;
        }
        if (arg instanceof Object) {
            castArg = (Object)arg;
            isValidArg = true;
        }
        if (arg instanceof Bnc) {
            castArg = (Bnc)arg;
            this._subobject = castArg.getSubobject();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (java.lang.Object)arg, (String)"[ObjectHeader, Object, Bnc]");
    }

    public static @NonNull BranchNodeList empty() {
        return LazyEmpty.INSTANCE;
    }

    public Boolean getIgnore() {
        return this._ignore;
    }

    public Boolean getProcessingRule() {
        return this._processingRule;
    }

    public List<Subobject> getSubobject() {
        return this._subobject;
    }

    public <E$$ extends Augmentation<BranchNodeList>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public BranchNodeListBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public BranchNodeListBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public BranchNodeListBuilder setSubobject(List<Subobject> values) {
        this._subobject = values;
        return this;
    }

    public BranchNodeListBuilder addAugmentation(Augmentation<BranchNodeList> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BranchNodeList>>, Augmentation<BranchNodeList>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public BranchNodeListBuilder removeAugmentation(Class<? extends Augmentation<BranchNodeList>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull BranchNodeList build() {
        return new BranchNodeListImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull BranchNodeList INSTANCE = new BranchNodeListBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class BranchNodeListImpl
    extends AbstractAugmentable<BranchNodeList>
    implements BranchNodeList {
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private final List<Subobject> _subobject;
        private int hash = 0;
        private volatile boolean hashValid = false;

        BranchNodeListImpl(BranchNodeListBuilder base) {
            super(base.augmentation);
            this._ignore = base.getIgnore();
            this._processingRule = base.getProcessingRule();
            this._subobject = CodeHelpers.emptyToNull(base.getSubobject());
        }

        @Override
        public Boolean getIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean getProcessingRule() {
            return this._processingRule;
        }

        @Override
        public List<Subobject> getSubobject() {
            return this._subobject;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = BranchNodeList.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(java.lang.Object obj) {
            return BranchNodeList.bindingEquals(this, obj);
        }

        public String toString() {
            return BranchNodeList.bindingToString(this);
        }
    }
}

