/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.p2mp.ipv4._case;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.EndpointsIpv4Source;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Ipv4Destinations;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.P2mpLeaves;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.P2mpLeavesLeaf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.p2mp.ipv4._case.P2mpIpv4;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class P2mpIpv4Builder {
    private Set<Ipv4AddressNoZone> _destinationIpv4Address;
    private P2mpLeaves _p2mpLeaves;
    private Ipv4AddressNoZone _sourceIpv4Address;
    Map<Class<? extends Augmentation<P2mpIpv4>>, Augmentation<P2mpIpv4>> augmentation = Map.of();

    public P2mpIpv4Builder() {
    }

    public P2mpIpv4Builder(P2mpLeavesLeaf arg) {
        this._p2mpLeaves = arg.getP2mpLeaves();
    }

    public P2mpIpv4Builder(EndpointsIpv4Source arg) {
        this._sourceIpv4Address = arg.getSourceIpv4Address();
    }

    public P2mpIpv4Builder(Ipv4Destinations arg) {
        this._destinationIpv4Address = arg.getDestinationIpv4Address();
    }

    public P2mpIpv4Builder(P2mpIpv4 base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<P2mpIpv4>>, Augmentation<P2mpIpv4>>(aug);
        }
        this._destinationIpv4Address = base.getDestinationIpv4Address();
        this._p2mpLeaves = base.getP2mpLeaves();
        this._sourceIpv4Address = base.getSourceIpv4Address();
    }

    public void fieldsFrom(DataObject arg) {
        Object castArg;
        boolean isValidArg = false;
        if (arg instanceof Ipv4Destinations) {
            castArg = (Ipv4Destinations)arg;
            this._destinationIpv4Address = castArg.getDestinationIpv4Address();
            isValidArg = true;
        }
        if (arg instanceof P2mpLeavesLeaf) {
            castArg = (P2mpLeavesLeaf)arg;
            this._p2mpLeaves = castArg.getP2mpLeaves();
            isValidArg = true;
        }
        if (arg instanceof EndpointsIpv4Source) {
            castArg = (EndpointsIpv4Source)arg;
            this._sourceIpv4Address = castArg.getSourceIpv4Address();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[Ipv4Destinations, P2mpLeavesLeaf, EndpointsIpv4Source]");
    }

    public static @NonNull P2mpIpv4 empty() {
        return LazyEmpty.INSTANCE;
    }

    public Set<Ipv4AddressNoZone> getDestinationIpv4Address() {
        return this._destinationIpv4Address;
    }

    public P2mpLeaves getP2mpLeaves() {
        return this._p2mpLeaves;
    }

    public Ipv4AddressNoZone getSourceIpv4Address() {
        return this._sourceIpv4Address;
    }

    public <E$$ extends Augmentation<P2mpIpv4>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public P2mpIpv4Builder setDestinationIpv4Address(Set<Ipv4AddressNoZone> values) {
        this._destinationIpv4Address = values;
        return this;
    }

    public P2mpIpv4Builder setP2mpLeaves(P2mpLeaves value) {
        this._p2mpLeaves = value;
        return this;
    }

    public P2mpIpv4Builder setSourceIpv4Address(Ipv4AddressNoZone value) {
        this._sourceIpv4Address = value;
        return this;
    }

    public P2mpIpv4Builder addAugmentation(Augmentation<P2mpIpv4> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<P2mpIpv4>>, Augmentation<P2mpIpv4>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public P2mpIpv4Builder removeAugmentation(Class<? extends Augmentation<P2mpIpv4>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull P2mpIpv4 build() {
        return new P2mpIpv4Impl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull P2mpIpv4 INSTANCE = new P2mpIpv4Builder().build();

        private LazyEmpty() {
        }
    }

    private static final class P2mpIpv4Impl
    extends AbstractAugmentable<P2mpIpv4>
    implements P2mpIpv4 {
        private final Set<Ipv4AddressNoZone> _destinationIpv4Address;
        private final P2mpLeaves _p2mpLeaves;
        private final Ipv4AddressNoZone _sourceIpv4Address;
        private int hash = 0;
        private volatile boolean hashValid = false;

        P2mpIpv4Impl(P2mpIpv4Builder base) {
            super(base.augmentation);
            this._destinationIpv4Address = base.getDestinationIpv4Address();
            this._p2mpLeaves = base.getP2mpLeaves();
            this._sourceIpv4Address = base.getSourceIpv4Address();
        }

        @Override
        public Set<Ipv4AddressNoZone> getDestinationIpv4Address() {
            return this._destinationIpv4Address;
        }

        @Override
        public P2mpLeaves getP2mpLeaves() {
            return this._p2mpLeaves;
        }

        @Override
        public Ipv4AddressNoZone getSourceIpv4Address() {
            return this._sourceIpv4Address;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = P2mpIpv4.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return P2mpIpv4.bindingEquals(this, obj);
        }

        public String toString() {
            return P2mpIpv4.bindingToString(this);
        }
    }
}

