/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.object;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Endpoints;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.object.EndpointsObj;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class EndpointsObjBuilder {
    private AddressFamily _addressFamily;
    private Boolean _ignore;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<EndpointsObj>>, Augmentation<EndpointsObj>> augmentation = Map.of();

    public EndpointsObjBuilder() {
    }

    public EndpointsObjBuilder(Object arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public EndpointsObjBuilder(ObjectHeader arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public EndpointsObjBuilder(Endpoints arg) {
        this._addressFamily = arg.getAddressFamily();
    }

    public EndpointsObjBuilder(EndpointsObj base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<EndpointsObj>>, Augmentation<EndpointsObj>>(aug);
        }
        this._addressFamily = base.getAddressFamily();
        this._ignore = base.getIgnore();
        this._processingRule = base.getProcessingRule();
    }

    public void fieldsFrom(DataObject arg) {
        java.lang.Object castArg;
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            castArg = (ObjectHeader)arg;
            this._processingRule = castArg.getProcessingRule();
            this._ignore = castArg.getIgnore();
            isValidArg = true;
        }
        if (arg instanceof Endpoints) {
            castArg = (Endpoints)arg;
            this._addressFamily = castArg.getAddressFamily();
            isValidArg = true;
        }
        if (arg instanceof Object) {
            castArg = (Object)arg;
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (java.lang.Object)arg, (String)"[ObjectHeader, Endpoints, Object]");
    }

    public static @NonNull EndpointsObj empty() {
        return LazyEmpty.INSTANCE;
    }

    public AddressFamily getAddressFamily() {
        return this._addressFamily;
    }

    public Boolean getIgnore() {
        return this._ignore;
    }

    public Boolean getProcessingRule() {
        return this._processingRule;
    }

    public <E$$ extends Augmentation<EndpointsObj>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public EndpointsObjBuilder setAddressFamily(AddressFamily value) {
        this._addressFamily = value;
        return this;
    }

    public EndpointsObjBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public EndpointsObjBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public EndpointsObjBuilder addAugmentation(Augmentation<EndpointsObj> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<EndpointsObj>>, Augmentation<EndpointsObj>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public EndpointsObjBuilder removeAugmentation(Class<? extends Augmentation<EndpointsObj>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull EndpointsObj build() {
        return new EndpointsObjImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull EndpointsObj INSTANCE = new EndpointsObjBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class EndpointsObjImpl
    extends AbstractAugmentable<EndpointsObj>
    implements EndpointsObj {
        private final AddressFamily _addressFamily;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private int hash = 0;
        private volatile boolean hashValid = false;

        EndpointsObjImpl(EndpointsObjBuilder base) {
            super(base.augmentation);
            this._addressFamily = base.getAddressFamily();
            this._ignore = base.getIgnore();
            this._processingRule = base.getProcessingRule();
        }

        @Override
        public AddressFamily getAddressFamily() {
            return this._addressFamily;
        }

        @Override
        public Boolean getIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean getProcessingRule() {
            return this._processingRule;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = EndpointsObj.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(java.lang.Object obj) {
            return EndpointsObj.bindingEquals(this, obj);
        }

        public String toString() {
            return EndpointsObj.bindingToString(this);
        }
    }
}

