/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.Xro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.xro.Subobject;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class XroBuilder {
    private Xro.Flags _flags;
    private Boolean _ignore;
    private Boolean _processingRule;
    private List<Subobject> _subobject;
    Map<Class<? extends Augmentation<Xro>>, Augmentation<Xro>> augmentation = Map.of();

    public XroBuilder() {
    }

    public XroBuilder(Object arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public XroBuilder(ObjectHeader arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public XroBuilder(Xro base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Xro>>, Augmentation<Xro>>(aug);
        }
        this._flags = base.getFlags();
        this._ignore = base.getIgnore();
        this._processingRule = base.getProcessingRule();
        this._subobject = base.getSubobject();
    }

    public void fieldsFrom(DataObject arg) {
        ObjectHeader castArg;
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            castArg = (ObjectHeader)arg;
            this._processingRule = castArg.getProcessingRule();
            this._ignore = castArg.getIgnore();
            isValidArg = true;
        }
        if (arg instanceof Object) {
            castArg = (Object)arg;
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (java.lang.Object)arg, (String)"[ObjectHeader, Object]");
    }

    public static @NonNull Xro empty() {
        return LazyEmpty.INSTANCE;
    }

    public Xro.Flags getFlags() {
        return this._flags;
    }

    public Boolean getIgnore() {
        return this._ignore;
    }

    public Boolean getProcessingRule() {
        return this._processingRule;
    }

    public List<Subobject> getSubobject() {
        return this._subobject;
    }

    public <E$$ extends Augmentation<Xro>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public XroBuilder setFlags(Xro.Flags value) {
        this._flags = value;
        return this;
    }

    public XroBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public XroBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public XroBuilder setSubobject(List<Subobject> values) {
        this._subobject = values;
        return this;
    }

    public XroBuilder addAugmentation(Augmentation<Xro> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Xro>>, Augmentation<Xro>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public XroBuilder removeAugmentation(Class<? extends Augmentation<Xro>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Xro build() {
        return new XroImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull Xro INSTANCE = new XroBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class XroImpl
    extends AbstractAugmentable<Xro>
    implements Xro {
        private final Xro.Flags _flags;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private final List<Subobject> _subobject;
        private int hash = 0;
        private volatile boolean hashValid = false;

        XroImpl(XroBuilder base) {
            super(base.augmentation);
            this._flags = base.getFlags();
            this._ignore = base.getIgnore();
            this._processingRule = base.getProcessingRule();
            this._subobject = CodeHelpers.emptyToNull(base.getSubobject());
        }

        @Override
        public Xro.Flags getFlags() {
            return this._flags;
        }

        @Override
        public Boolean getIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean getProcessingRule() {
            return this._processingRule;
        }

        @Override
        public List<Subobject> getSubobject() {
            return this._subobject;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Xro.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(java.lang.Object obj) {
            return Xro.bindingEquals(this, obj);
        }

        public String toString() {
            return Xro.bindingToString(this);
        }
    }
}

