/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.gc.object;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.gc.object.Gc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.gc.object.gc.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.gc.object.gc.TlvsBuilder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

public class GcBuilder {
    private Boolean _ignore;
    private Uint8 _maxHop;
    private Uint8 _maxUtilization;
    private Uint8 _minUtilization;
    private Uint8 _overBookingFactor;
    private Boolean _processingRule;
    private Tlvs _tlvs;
    Map<Class<? extends Augmentation<Gc>>, Augmentation<Gc>> augmentation = Map.of();

    public GcBuilder() {
    }

    public GcBuilder(Object arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public GcBuilder(ObjectHeader arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public GcBuilder(Gc base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Gc>>, Augmentation<Gc>>(aug);
        }
        this._ignore = base.getIgnore();
        this._maxHop = base.getMaxHop();
        this._maxUtilization = base.getMaxUtilization();
        this._minUtilization = base.getMinUtilization();
        this._overBookingFactor = base.getOverBookingFactor();
        this._processingRule = base.getProcessingRule();
        this._tlvs = base.getTlvs();
    }

    public void fieldsFrom(DataObject arg) {
        ObjectHeader castArg;
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            castArg = (ObjectHeader)arg;
            this._processingRule = castArg.getProcessingRule();
            this._ignore = castArg.getIgnore();
            isValidArg = true;
        }
        if (arg instanceof Object) {
            castArg = (Object)arg;
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (java.lang.Object)arg, (String)"[ObjectHeader, Object]");
    }

    public static @NonNull Gc empty() {
        return LazyEmpty.INSTANCE;
    }

    public Boolean getIgnore() {
        return this._ignore;
    }

    public Uint8 getMaxHop() {
        return this._maxHop;
    }

    public Uint8 getMaxUtilization() {
        return this._maxUtilization;
    }

    public Uint8 getMinUtilization() {
        return this._minUtilization;
    }

    public Uint8 getOverBookingFactor() {
        return this._overBookingFactor;
    }

    public Boolean getProcessingRule() {
        return this._processingRule;
    }

    public Tlvs getTlvs() {
        return this._tlvs;
    }

    public <E$$ extends Augmentation<Gc>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public GcBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public GcBuilder setMaxHop(Uint8 value) {
        this._maxHop = value;
        return this;
    }

    private static void checkMaxUtilizationRange(short value) {
        if (value <= 100) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..100]]", (int)value);
    }

    public GcBuilder setMaxUtilization(Uint8 value) {
        if (value != null) {
            GcBuilder.checkMaxUtilizationRange(value.shortValue());
        }
        this._maxUtilization = value;
        return this;
    }

    private static void checkMinUtilizationRange(short value) {
        if (value <= 100) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..100]]", (int)value);
    }

    public GcBuilder setMinUtilization(Uint8 value) {
        if (value != null) {
            GcBuilder.checkMinUtilizationRange(value.shortValue());
        }
        this._minUtilization = value;
        return this;
    }

    private static void checkOverBookingFactorRange(short value) {
        if (value <= 100) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..100]]", (int)value);
    }

    public GcBuilder setOverBookingFactor(Uint8 value) {
        if (value != null) {
            GcBuilder.checkOverBookingFactorRange(value.shortValue());
        }
        this._overBookingFactor = value;
        return this;
    }

    public GcBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public GcBuilder setTlvs(Tlvs value) {
        this._tlvs = value;
        return this;
    }

    public GcBuilder addAugmentation(Augmentation<Gc> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Gc>>, Augmentation<Gc>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public GcBuilder removeAugmentation(Class<? extends Augmentation<Gc>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Gc build() {
        return new GcImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull Gc INSTANCE = new GcBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class GcImpl
    extends AbstractAugmentable<Gc>
    implements Gc {
        private final Boolean _ignore;
        private final Uint8 _maxHop;
        private final Uint8 _maxUtilization;
        private final Uint8 _minUtilization;
        private final Uint8 _overBookingFactor;
        private final Boolean _processingRule;
        private final Tlvs _tlvs;
        private int hash = 0;
        private volatile boolean hashValid = false;

        GcImpl(GcBuilder base) {
            super(base.augmentation);
            this._ignore = base.getIgnore();
            this._maxHop = base.getMaxHop();
            this._maxUtilization = base.getMaxUtilization();
            this._minUtilization = base.getMinUtilization();
            this._overBookingFactor = base.getOverBookingFactor();
            this._processingRule = base.getProcessingRule();
            this._tlvs = base.getTlvs();
        }

        @Override
        public Boolean getIgnore() {
            return this._ignore;
        }

        @Override
        public Uint8 getMaxHop() {
            return this._maxHop;
        }

        @Override
        public Uint8 getMaxUtilization() {
            return this._maxUtilization;
        }

        @Override
        public Uint8 getMinUtilization() {
            return this._minUtilization;
        }

        @Override
        public Uint8 getOverBookingFactor() {
            return this._overBookingFactor;
        }

        @Override
        public Boolean getProcessingRule() {
            return this._processingRule;
        }

        @Override
        public Tlvs getTlvs() {
            return this._tlvs;
        }

        @Override
        public Tlvs nonnullTlvs() {
            return Objects.requireNonNullElse(this.getTlvs(), TlvsBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Gc.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(java.lang.Object obj) {
            return Gc.bindingEquals(this, obj);
        }

        public String toString() {
            return Gc.bindingToString(this);
        }
    }
}

