/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lsp.attributes;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.MetricObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lsp.attributes.Metrics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.metric.object.Metric;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.metric.object.MetricBuilder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MetricsBuilder {
    private Metric _metric;
    Map<Class<? extends Augmentation<Metrics>>, Augmentation<Metrics>> augmentation = Map.of();

    public MetricsBuilder() {
    }

    public MetricsBuilder(MetricObject arg) {
        this._metric = arg.getMetric();
    }

    public MetricsBuilder(Metrics base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Metrics>>, Augmentation<Metrics>>(aug);
        }
        this._metric = base.getMetric();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MetricObject) {
            MetricObject castArg = (MetricObject)arg;
            this._metric = castArg.getMetric();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[MetricObject]");
    }

    public Metric getMetric() {
        return this._metric;
    }

    public <E$$ extends Augmentation<Metrics>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public MetricsBuilder setMetric(Metric value) {
        this._metric = value;
        return this;
    }

    public MetricsBuilder addAugmentation(Augmentation<Metrics> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Metrics>>, Augmentation<Metrics>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public MetricsBuilder removeAugmentation(Class<? extends Augmentation<Metrics>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Metrics build() {
        return new MetricsImpl(this);
    }

    private static final class MetricsImpl
    extends AbstractAugmentable<Metrics>
    implements Metrics {
        private final Metric _metric;
        private int hash = 0;
        private volatile boolean hashValid = false;

        MetricsImpl(MetricsBuilder base) {
            super(base.augmentation);
            this._metric = base.getMetric();
        }

        @Override
        public Metric getMetric() {
            return this._metric;
        }

        @Override
        public Metric nonnullMetric() {
            return Objects.requireNonNullElse(this.getMetric(), MetricBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Metrics.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Metrics.bindingEquals(this, obj);
        }

        public String toString() {
            return Metrics.bindingToString(this);
        }
    }
}

