/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.Lspa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.lspa.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.lspa.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

public class LspaBuilder {
    private AttributeFilter _excludeAny;
    private Uint8 _holdPriority;
    private Boolean _ignore;
    private AttributeFilter _includeAll;
    private AttributeFilter _includeAny;
    private Boolean _labelRecordingDesired;
    private Boolean _localProtectionDesired;
    private Boolean _processingRule;
    private Boolean _seStyleDesired;
    private String _sessionName;
    private Uint8 _setupPriority;
    private Tlvs _tlvs;
    Map<Class<? extends Augmentation<Lspa>>, Augmentation<Lspa>> augmentation = Map.of();

    public LspaBuilder() {
    }

    public LspaBuilder(Object arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public LspaBuilder(ObjectHeader arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public LspaBuilder(TunnelAttributes arg) {
        this._localProtectionDesired = arg.getLocalProtectionDesired();
        this._labelRecordingDesired = arg.getLabelRecordingDesired();
        this._seStyleDesired = arg.getSeStyleDesired();
        this._sessionName = arg.getSessionName();
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }

    public LspaBuilder(Priority arg) {
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
    }

    public LspaBuilder(AttributeFilters arg) {
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }

    public LspaBuilder(Lspa base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Lspa>>, Augmentation<Lspa>>(aug);
        }
        this._excludeAny = base.getExcludeAny();
        this._holdPriority = base.getHoldPriority();
        this._ignore = base.getIgnore();
        this._includeAll = base.getIncludeAll();
        this._includeAny = base.getIncludeAny();
        this._labelRecordingDesired = base.getLabelRecordingDesired();
        this._localProtectionDesired = base.getLocalProtectionDesired();
        this._processingRule = base.getProcessingRule();
        this._seStyleDesired = base.getSeStyleDesired();
        this._sessionName = base.getSessionName();
        this._setupPriority = base.getSetupPriority();
        this._tlvs = base.getTlvs();
    }

    public void fieldsFrom(DataObject arg) {
        ObjectHeader castArg;
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            castArg = (ObjectHeader)arg;
            this._processingRule = castArg.getProcessingRule();
            this._ignore = castArg.getIgnore();
            isValidArg = true;
        }
        if (arg instanceof Priority) {
            castArg = (Priority)arg;
            this._holdPriority = castArg.getHoldPriority();
            this._setupPriority = castArg.getSetupPriority();
            isValidArg = true;
        }
        if (arg instanceof AttributeFilters) {
            castArg = (AttributeFilters)arg;
            this._includeAny = castArg.getIncludeAny();
            this._excludeAny = castArg.getExcludeAny();
            this._includeAll = castArg.getIncludeAll();
            isValidArg = true;
        }
        if (arg instanceof TunnelAttributes) {
            castArg = (TunnelAttributes)arg;
            this._localProtectionDesired = castArg.getLocalProtectionDesired();
            this._labelRecordingDesired = castArg.getLabelRecordingDesired();
            this._seStyleDesired = castArg.getSeStyleDesired();
            this._sessionName = castArg.getSessionName();
            isValidArg = true;
        }
        if (arg instanceof Object) {
            castArg = (Object)arg;
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (java.lang.Object)arg, (String)"[ObjectHeader, Priority, AttributeFilters, TunnelAttributes, Object]");
    }

    public static @NonNull Lspa empty() {
        return LazyEmpty.INSTANCE;
    }

    public AttributeFilter getExcludeAny() {
        return this._excludeAny;
    }

    public Uint8 getHoldPriority() {
        return this._holdPriority;
    }

    public Boolean getIgnore() {
        return this._ignore;
    }

    public AttributeFilter getIncludeAll() {
        return this._includeAll;
    }

    public AttributeFilter getIncludeAny() {
        return this._includeAny;
    }

    public Boolean getLabelRecordingDesired() {
        return this._labelRecordingDesired;
    }

    public Boolean getLocalProtectionDesired() {
        return this._localProtectionDesired;
    }

    public Boolean getProcessingRule() {
        return this._processingRule;
    }

    public Boolean getSeStyleDesired() {
        return this._seStyleDesired;
    }

    public String getSessionName() {
        return this._sessionName;
    }

    public Uint8 getSetupPriority() {
        return this._setupPriority;
    }

    public Tlvs getTlvs() {
        return this._tlvs;
    }

    public <E$$ extends Augmentation<Lspa>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public LspaBuilder setExcludeAny(AttributeFilter value) {
        this._excludeAny = value;
        return this;
    }

    public LspaBuilder setHoldPriority(Uint8 value) {
        this._holdPriority = value;
        return this;
    }

    public LspaBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public LspaBuilder setIncludeAll(AttributeFilter value) {
        this._includeAll = value;
        return this;
    }

    public LspaBuilder setIncludeAny(AttributeFilter value) {
        this._includeAny = value;
        return this;
    }

    public LspaBuilder setLabelRecordingDesired(Boolean value) {
        this._labelRecordingDesired = value;
        return this;
    }

    public LspaBuilder setLocalProtectionDesired(Boolean value) {
        this._localProtectionDesired = value;
        return this;
    }

    public LspaBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public LspaBuilder setSeStyleDesired(Boolean value) {
        this._seStyleDesired = value;
        return this;
    }

    public LspaBuilder setSessionName(String value) {
        this._sessionName = value;
        return this;
    }

    public LspaBuilder setSetupPriority(Uint8 value) {
        this._setupPriority = value;
        return this;
    }

    public LspaBuilder setTlvs(Tlvs value) {
        this._tlvs = value;
        return this;
    }

    public LspaBuilder addAugmentation(Augmentation<Lspa> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Lspa>>, Augmentation<Lspa>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public LspaBuilder removeAugmentation(Class<? extends Augmentation<Lspa>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Lspa build() {
        return new LspaImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull Lspa INSTANCE = new LspaBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class LspaImpl
    extends AbstractAugmentable<Lspa>
    implements Lspa {
        private final AttributeFilter _excludeAny;
        private final Uint8 _holdPriority;
        private final Boolean _ignore;
        private final AttributeFilter _includeAll;
        private final AttributeFilter _includeAny;
        private final Boolean _labelRecordingDesired;
        private final Boolean _localProtectionDesired;
        private final Boolean _processingRule;
        private final Boolean _seStyleDesired;
        private final String _sessionName;
        private final Uint8 _setupPriority;
        private final Tlvs _tlvs;
        private int hash = 0;
        private volatile boolean hashValid = false;

        LspaImpl(LspaBuilder base) {
            super(base.augmentation);
            this._excludeAny = base.getExcludeAny();
            this._holdPriority = base.getHoldPriority();
            this._ignore = base.getIgnore();
            this._includeAll = base.getIncludeAll();
            this._includeAny = base.getIncludeAny();
            this._labelRecordingDesired = base.getLabelRecordingDesired();
            this._localProtectionDesired = base.getLocalProtectionDesired();
            this._processingRule = base.getProcessingRule();
            this._seStyleDesired = base.getSeStyleDesired();
            this._sessionName = base.getSessionName();
            this._setupPriority = base.getSetupPriority();
            this._tlvs = base.getTlvs();
        }

        public AttributeFilter getExcludeAny() {
            return this._excludeAny;
        }

        public Uint8 getHoldPriority() {
            return this._holdPriority;
        }

        @Override
        public Boolean getIgnore() {
            return this._ignore;
        }

        public AttributeFilter getIncludeAll() {
            return this._includeAll;
        }

        public AttributeFilter getIncludeAny() {
            return this._includeAny;
        }

        public Boolean getLabelRecordingDesired() {
            return this._labelRecordingDesired;
        }

        public Boolean getLocalProtectionDesired() {
            return this._localProtectionDesired;
        }

        @Override
        public Boolean getProcessingRule() {
            return this._processingRule;
        }

        public Boolean getSeStyleDesired() {
            return this._seStyleDesired;
        }

        public String getSessionName() {
            return this._sessionName;
        }

        public Uint8 getSetupPriority() {
            return this._setupPriority;
        }

        @Override
        public Tlvs getTlvs() {
            return this._tlvs;
        }

        @Override
        public Tlvs nonnullTlvs() {
            return Objects.requireNonNullElse(this.getTlvs(), TlvsBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Lspa.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(java.lang.Object obj) {
            return Lspa.bindingEquals(this, obj);
        }

        public String toString() {
            return Lspa.bindingToString(this);
        }
    }
}

