/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.metric.object;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819.Float32;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.metric.object.Metric;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

public class MetricBuilder {
    private Boolean _bound;
    private Boolean _computed;
    private Boolean _ignore;
    private Uint8 _metricType;
    private Boolean _processingRule;
    private Float32 _value;
    Map<Class<? extends Augmentation<Metric>>, Augmentation<Metric>> augmentation = Map.of();

    public MetricBuilder() {
    }

    public MetricBuilder(Object arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public MetricBuilder(ObjectHeader arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public MetricBuilder(Metric base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Metric>>, Augmentation<Metric>>(aug);
        }
        this._bound = base.getBound();
        this._computed = base.getComputed();
        this._ignore = base.getIgnore();
        this._metricType = base.getMetricType();
        this._processingRule = base.getProcessingRule();
        this._value = base.getValue();
    }

    public void fieldsFrom(DataObject arg) {
        ObjectHeader castArg;
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            castArg = (ObjectHeader)arg;
            this._processingRule = castArg.getProcessingRule();
            this._ignore = castArg.getIgnore();
            isValidArg = true;
        }
        if (arg instanceof Object) {
            castArg = (Object)arg;
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (java.lang.Object)arg, (String)"[ObjectHeader, Object]");
    }

    public static @NonNull Metric empty() {
        return LazyEmpty.INSTANCE;
    }

    public Boolean getBound() {
        return this._bound;
    }

    public Boolean getComputed() {
        return this._computed;
    }

    public Boolean getIgnore() {
        return this._ignore;
    }

    public Uint8 getMetricType() {
        return this._metricType;
    }

    public Boolean getProcessingRule() {
        return this._processingRule;
    }

    public Float32 getValue() {
        return this._value;
    }

    public <E$$ extends Augmentation<Metric>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public MetricBuilder setBound(Boolean value) {
        this._bound = value;
        return this;
    }

    public MetricBuilder setComputed(Boolean value) {
        this._computed = value;
        return this;
    }

    public MetricBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public MetricBuilder setMetricType(Uint8 value) {
        this._metricType = value;
        return this;
    }

    public MetricBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public MetricBuilder setValue(Float32 value) {
        this._value = value;
        return this;
    }

    public MetricBuilder addAugmentation(Augmentation<Metric> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Metric>>, Augmentation<Metric>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public MetricBuilder removeAugmentation(Class<? extends Augmentation<Metric>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Metric build() {
        return new MetricImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull Metric INSTANCE = new MetricBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class MetricImpl
    extends AbstractAugmentable<Metric>
    implements Metric {
        private final Boolean _bound;
        private final Boolean _computed;
        private final Boolean _ignore;
        private final Uint8 _metricType;
        private final Boolean _processingRule;
        private final Float32 _value;
        private int hash = 0;
        private volatile boolean hashValid = false;

        MetricImpl(MetricBuilder base) {
            super(base.augmentation);
            this._bound = base.getBound();
            this._computed = base.getComputed();
            this._ignore = base.getIgnore();
            this._metricType = base.getMetricType();
            this._processingRule = base.getProcessingRule();
            this._value = base.getValue();
        }

        @Override
        public Boolean getBound() {
            return this._bound;
        }

        @Override
        public Boolean getComputed() {
            return this._computed;
        }

        @Override
        public Boolean getIgnore() {
            return this._ignore;
        }

        @Override
        public Uint8 getMetricType() {
            return this._metricType;
        }

        @Override
        public Boolean getProcessingRule() {
            return this._processingRule;
        }

        @Override
        public Float32 getValue() {
            return this._value;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Metric.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(java.lang.Object obj) {
            return Metric.bindingEquals(this, obj);
        }

        public String toString() {
            return Metric.bindingToString(this);
        }
    }
}

