/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.OverloadObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.PceIdObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ProcTimeObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.metrics.MetricPce;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.overload.object.Overload;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.overload.object.OverloadBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pce.id.object.PceId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pce.id.object.PceIdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.proc.time.object.ProcTime;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.proc.time.object.ProcTimeBuilder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MetricPceBuilder {
    private Overload _overload;
    private PceId _pceId;
    private ProcTime _procTime;
    Map<Class<? extends Augmentation<MetricPce>>, Augmentation<MetricPce>> augmentation = Map.of();

    public MetricPceBuilder() {
    }

    public MetricPceBuilder(PceIdObject arg) {
        this._pceId = arg.getPceId();
    }

    public MetricPceBuilder(ProcTimeObject arg) {
        this._procTime = arg.getProcTime();
    }

    public MetricPceBuilder(OverloadObject arg) {
        this._overload = arg.getOverload();
    }

    public MetricPceBuilder(MetricPce base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MetricPce>>, Augmentation<MetricPce>>(aug);
        }
        this._overload = base.getOverload();
        this._pceId = base.getPceId();
        this._procTime = base.getProcTime();
    }

    public void fieldsFrom(DataObject arg) {
        Object castArg;
        boolean isValidArg = false;
        if (arg instanceof OverloadObject) {
            castArg = (OverloadObject)arg;
            this._overload = castArg.getOverload();
            isValidArg = true;
        }
        if (arg instanceof PceIdObject) {
            castArg = (PceIdObject)arg;
            this._pceId = castArg.getPceId();
            isValidArg = true;
        }
        if (arg instanceof ProcTimeObject) {
            castArg = (ProcTimeObject)arg;
            this._procTime = castArg.getProcTime();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[OverloadObject, PceIdObject, ProcTimeObject]");
    }

    public Overload getOverload() {
        return this._overload;
    }

    public PceId getPceId() {
        return this._pceId;
    }

    public ProcTime getProcTime() {
        return this._procTime;
    }

    public <E$$ extends Augmentation<MetricPce>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public MetricPceBuilder setOverload(Overload value) {
        this._overload = value;
        return this;
    }

    public MetricPceBuilder setPceId(PceId value) {
        this._pceId = value;
        return this;
    }

    public MetricPceBuilder setProcTime(ProcTime value) {
        this._procTime = value;
        return this;
    }

    public MetricPceBuilder addAugmentation(Augmentation<MetricPce> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MetricPce>>, Augmentation<MetricPce>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public MetricPceBuilder removeAugmentation(Class<? extends Augmentation<MetricPce>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull MetricPce build() {
        return new MetricPceImpl(this);
    }

    private static final class MetricPceImpl
    extends AbstractAugmentable<MetricPce>
    implements MetricPce {
        private final Overload _overload;
        private final PceId _pceId;
        private final ProcTime _procTime;
        private int hash = 0;
        private volatile boolean hashValid = false;

        MetricPceImpl(MetricPceBuilder base) {
            super(base.augmentation);
            this._overload = base.getOverload();
            this._pceId = base.getPceId();
            this._procTime = base.getProcTime();
        }

        @Override
        public Overload getOverload() {
            return this._overload;
        }

        @Override
        public PceId getPceId() {
            return this._pceId;
        }

        @Override
        public ProcTime getProcTime() {
            return this._procTime;
        }

        @Override
        public Overload nonnullOverload() {
            return Objects.requireNonNullElse(this.getOverload(), OverloadBuilder.empty());
        }

        @Override
        public PceId nonnullPceId() {
            return Objects.requireNonNullElse(this.getPceId(), PceIdBuilder.empty());
        }

        @Override
        public ProcTime nonnullProcTime() {
            return Objects.requireNonNullElse(this.getProcTime(), ProcTimeBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = MetricPce.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return MetricPce.bindingEquals(this, obj);
        }

        public String toString() {
            return MetricPce.bindingToString(this);
        }
    }
}

