/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.response.monitoring.metrics.list.specific.metrics.list;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.MonitoringMetrics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.RpObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.metrics.MetricPce;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.response.monitoring.metrics.list.specific.metrics.list.SpecificMetrics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.Rp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.RpBuilder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SpecificMetricsBuilder {
    private List<MetricPce> _metricPce;
    private Rp _rp;
    Map<Class<? extends Augmentation<SpecificMetrics>>, Augmentation<SpecificMetrics>> augmentation = Map.of();

    public SpecificMetricsBuilder() {
    }

    public SpecificMetricsBuilder(RpObject arg) {
        this._rp = arg.getRp();
    }

    public SpecificMetricsBuilder(MonitoringMetrics arg) {
        this._metricPce = arg.getMetricPce();
    }

    public SpecificMetricsBuilder(SpecificMetrics base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SpecificMetrics>>, Augmentation<SpecificMetrics>>(aug);
        }
        this._metricPce = base.getMetricPce();
        this._rp = base.getRp();
    }

    public void fieldsFrom(DataObject arg) {
        Object castArg;
        boolean isValidArg = false;
        if (arg instanceof MonitoringMetrics) {
            castArg = (MonitoringMetrics)arg;
            this._metricPce = castArg.getMetricPce();
            isValidArg = true;
        }
        if (arg instanceof RpObject) {
            castArg = (RpObject)arg;
            this._rp = castArg.getRp();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[MonitoringMetrics, RpObject]");
    }

    public List<MetricPce> getMetricPce() {
        return this._metricPce;
    }

    public Rp getRp() {
        return this._rp;
    }

    public <E$$ extends Augmentation<SpecificMetrics>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public SpecificMetricsBuilder setMetricPce(List<MetricPce> values) {
        this._metricPce = values;
        return this;
    }

    public SpecificMetricsBuilder setRp(Rp value) {
        this._rp = value;
        return this;
    }

    public SpecificMetricsBuilder addAugmentation(Augmentation<SpecificMetrics> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SpecificMetrics>>, Augmentation<SpecificMetrics>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public SpecificMetricsBuilder removeAugmentation(Class<? extends Augmentation<SpecificMetrics>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull SpecificMetrics build() {
        return new SpecificMetricsImpl(this);
    }

    private static final class SpecificMetricsImpl
    extends AbstractAugmentable<SpecificMetrics>
    implements SpecificMetrics {
        private final List<MetricPce> _metricPce;
        private final Rp _rp;
        private int hash = 0;
        private volatile boolean hashValid = false;

        SpecificMetricsImpl(SpecificMetricsBuilder base) {
            super(base.augmentation);
            this._metricPce = CodeHelpers.emptyToNull(base.getMetricPce());
            this._rp = base.getRp();
        }

        @Override
        public List<MetricPce> getMetricPce() {
            return this._metricPce;
        }

        @Override
        public Rp getRp() {
            return this._rp;
        }

        @Override
        public Rp nonnullRp() {
            return Objects.requireNonNullElse(this.getRp(), RpBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = SpecificMetrics.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return SpecificMetrics.bindingEquals(this, obj);
        }

        public String toString() {
            return SpecificMetrics.bindingToString(this);
        }
    }
}

