/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.object;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.OfId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.object.Of;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.object.of.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.object.of.TlvsBuilder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OfBuilder {
    private OfId _code;
    private Boolean _ignore;
    private Boolean _processingRule;
    private Tlvs _tlvs;
    Map<Class<? extends Augmentation<Of>>, Augmentation<Of>> augmentation = Map.of();

    public OfBuilder() {
    }

    public OfBuilder(Object arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public OfBuilder(ObjectHeader arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public OfBuilder(Of base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Of>>, Augmentation<Of>>(aug);
        }
        this._code = base.getCode();
        this._ignore = base.getIgnore();
        this._processingRule = base.getProcessingRule();
        this._tlvs = base.getTlvs();
    }

    public void fieldsFrom(DataObject arg) {
        ObjectHeader castArg;
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            castArg = (ObjectHeader)arg;
            this._processingRule = castArg.getProcessingRule();
            this._ignore = castArg.getIgnore();
            isValidArg = true;
        }
        if (arg instanceof Object) {
            castArg = (Object)arg;
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (java.lang.Object)arg, (String)"[ObjectHeader, Object]");
    }

    public static @NonNull Of empty() {
        return LazyEmpty.INSTANCE;
    }

    public OfId getCode() {
        return this._code;
    }

    public Boolean getIgnore() {
        return this._ignore;
    }

    public Boolean getProcessingRule() {
        return this._processingRule;
    }

    public Tlvs getTlvs() {
        return this._tlvs;
    }

    public <E$$ extends Augmentation<Of>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public OfBuilder setCode(OfId value) {
        this._code = value;
        return this;
    }

    public OfBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public OfBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public OfBuilder setTlvs(Tlvs value) {
        this._tlvs = value;
        return this;
    }

    public OfBuilder addAugmentation(Augmentation<Of> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Of>>, Augmentation<Of>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public OfBuilder removeAugmentation(Class<? extends Augmentation<Of>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Of build() {
        return new OfImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull Of INSTANCE = new OfBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class OfImpl
    extends AbstractAugmentable<Of>
    implements Of {
        private final OfId _code;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private final Tlvs _tlvs;
        private int hash = 0;
        private volatile boolean hashValid = false;

        OfImpl(OfBuilder base) {
            super(base.augmentation);
            this._code = base.getCode();
            this._ignore = base.getIgnore();
            this._processingRule = base.getProcessingRule();
            this._tlvs = base.getTlvs();
        }

        @Override
        public OfId getCode() {
            return this._code;
        }

        @Override
        public Boolean getIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean getProcessingRule() {
            return this._processingRule;
        }

        @Override
        public Tlvs getTlvs() {
            return this._tlvs;
        }

        @Override
        public Tlvs nonnullTlvs() {
            return Objects.requireNonNullElse(this.getTlvs(), TlvsBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Of.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(java.lang.Object obj) {
            return Of.bindingEquals(this, obj);
        }

        public String toString() {
            return Of.bindingToString(this);
        }
    }
}

