/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.open.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.open.TlvsBuilder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

public class OpenBuilder {
    private Uint8 _deadTimer;
    private Boolean _ignore;
    private Uint8 _keepalive;
    private Boolean _processingRule;
    private Uint8 _sessionId;
    private Tlvs _tlvs;
    private ProtocolVersion _version;
    Map<Class<? extends Augmentation<Open>>, Augmentation<Open>> augmentation = Map.of();

    public OpenBuilder() {
    }

    public OpenBuilder(Object arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public OpenBuilder(ObjectHeader arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public OpenBuilder(Open base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Open>>, Augmentation<Open>>(aug);
        }
        this._deadTimer = base.getDeadTimer();
        this._ignore = base.getIgnore();
        this._keepalive = base.getKeepalive();
        this._processingRule = base.getProcessingRule();
        this._sessionId = base.getSessionId();
        this._tlvs = base.getTlvs();
        this._version = base.getVersion();
    }

    public void fieldsFrom(DataObject arg) {
        ObjectHeader castArg;
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            castArg = (ObjectHeader)arg;
            this._processingRule = castArg.getProcessingRule();
            this._ignore = castArg.getIgnore();
            isValidArg = true;
        }
        if (arg instanceof Object) {
            castArg = (Object)arg;
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (java.lang.Object)arg, (String)"[ObjectHeader, Object]");
    }

    public static @NonNull Open empty() {
        return LazyEmpty.INSTANCE;
    }

    public Uint8 getDeadTimer() {
        return this._deadTimer;
    }

    public Boolean getIgnore() {
        return this._ignore;
    }

    public Uint8 getKeepalive() {
        return this._keepalive;
    }

    public Boolean getProcessingRule() {
        return this._processingRule;
    }

    public Uint8 getSessionId() {
        return this._sessionId;
    }

    public Tlvs getTlvs() {
        return this._tlvs;
    }

    public ProtocolVersion getVersion() {
        return this._version;
    }

    public <E$$ extends Augmentation<Open>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    private static void checkDeadTimerRange(short value) {
    }

    public OpenBuilder setDeadTimer(Uint8 value) {
        if (value != null) {
            OpenBuilder.checkDeadTimerRange(value.shortValue());
        }
        this._deadTimer = value;
        return this;
    }

    public OpenBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    private static void checkKeepaliveRange(short value) {
    }

    public OpenBuilder setKeepalive(Uint8 value) {
        if (value != null) {
            OpenBuilder.checkKeepaliveRange(value.shortValue());
        }
        this._keepalive = value;
        return this;
    }

    public OpenBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public OpenBuilder setSessionId(Uint8 value) {
        this._sessionId = value;
        return this;
    }

    public OpenBuilder setTlvs(Tlvs value) {
        this._tlvs = value;
        return this;
    }

    public OpenBuilder setVersion(ProtocolVersion value) {
        this._version = value;
        return this;
    }

    public OpenBuilder addAugmentation(Augmentation<Open> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Open>>, Augmentation<Open>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public OpenBuilder removeAugmentation(Class<? extends Augmentation<Open>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Open build() {
        return new OpenImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull Open INSTANCE = new OpenBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class OpenImpl
    extends AbstractAugmentable<Open>
    implements Open {
        private final Uint8 _deadTimer;
        private final Boolean _ignore;
        private final Uint8 _keepalive;
        private final Boolean _processingRule;
        private final Uint8 _sessionId;
        private final Tlvs _tlvs;
        private final ProtocolVersion _version;
        private int hash = 0;
        private volatile boolean hashValid = false;

        OpenImpl(OpenBuilder base) {
            super(base.augmentation);
            this._deadTimer = base.getDeadTimer();
            this._ignore = base.getIgnore();
            this._keepalive = base.getKeepalive();
            this._processingRule = base.getProcessingRule();
            this._sessionId = base.getSessionId();
            this._tlvs = base.getTlvs();
            this._version = base.getVersion();
        }

        @Override
        public Uint8 getDeadTimer() {
            return this._deadTimer;
        }

        @Override
        public Boolean getIgnore() {
            return this._ignore;
        }

        @Override
        public Uint8 getKeepalive() {
            return this._keepalive;
        }

        @Override
        public Boolean getProcessingRule() {
            return this._processingRule;
        }

        @Override
        public Uint8 getSessionId() {
            return this._sessionId;
        }

        @Override
        public Tlvs getTlvs() {
            return this._tlvs;
        }

        @Override
        public ProtocolVersion getVersion() {
            return this._version;
        }

        @Override
        public Tlvs nonnullTlvs() {
            return Objects.requireNonNullElse(this.getTlvs(), TlvsBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Open.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(java.lang.Object obj) {
            return Open.bindingEquals(this, obj);
        }

        public String toString() {
            return Open.bindingToString(this);
        }
    }
}

