/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.path.key.object;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.path.key.object.PathKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.path.key.object.path.key.PathKeys;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PathKeyBuilder {
    private Boolean _ignore;
    private List<PathKeys> _pathKeys;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<PathKey>>, Augmentation<PathKey>> augmentation = Map.of();

    public PathKeyBuilder() {
    }

    public PathKeyBuilder(Object arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public PathKeyBuilder(ObjectHeader arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public PathKeyBuilder(PathKey base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PathKey>>, Augmentation<PathKey>>(aug);
        }
        this._ignore = base.getIgnore();
        this._pathKeys = base.getPathKeys();
        this._processingRule = base.getProcessingRule();
    }

    public void fieldsFrom(DataObject arg) {
        ObjectHeader castArg;
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            castArg = (ObjectHeader)arg;
            this._processingRule = castArg.getProcessingRule();
            this._ignore = castArg.getIgnore();
            isValidArg = true;
        }
        if (arg instanceof Object) {
            castArg = (Object)arg;
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (java.lang.Object)arg, (String)"[ObjectHeader, Object]");
    }

    public static @NonNull PathKey empty() {
        return LazyEmpty.INSTANCE;
    }

    public Boolean getIgnore() {
        return this._ignore;
    }

    public List<PathKeys> getPathKeys() {
        return this._pathKeys;
    }

    public Boolean getProcessingRule() {
        return this._processingRule;
    }

    public <E$$ extends Augmentation<PathKey>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public PathKeyBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public PathKeyBuilder setPathKeys(List<PathKeys> values) {
        this._pathKeys = values;
        return this;
    }

    public PathKeyBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public PathKeyBuilder addAugmentation(Augmentation<PathKey> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PathKey>>, Augmentation<PathKey>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public PathKeyBuilder removeAugmentation(Class<? extends Augmentation<PathKey>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull PathKey build() {
        return new PathKeyImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull PathKey INSTANCE = new PathKeyBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class PathKeyImpl
    extends AbstractAugmentable<PathKey>
    implements PathKey {
        private final Boolean _ignore;
        private final List<PathKeys> _pathKeys;
        private final Boolean _processingRule;
        private int hash = 0;
        private volatile boolean hashValid = false;

        PathKeyImpl(PathKeyBuilder base) {
            super(base.augmentation);
            this._ignore = base.getIgnore();
            this._pathKeys = CodeHelpers.emptyToNull(base.getPathKeys());
            this._processingRule = base.getProcessingRule();
        }

        @Override
        public Boolean getIgnore() {
            return this._ignore;
        }

        @Override
        public List<PathKeys> getPathKeys() {
            return this._pathKeys;
        }

        @Override
        public Boolean getProcessingRule() {
            return this._processingRule;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = PathKey.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(java.lang.Object obj) {
            return PathKey.bindingEquals(this, obj);
        }

        public String toString() {
            return PathKey.bindingToString(this);
        }
    }
}

