/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.MessageHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.PcreqMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.MonitoringRequest;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.MonitoringRequestBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.Requests;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.Svec;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PcreqMessageBuilder {
    private MonitoringRequest _monitoringRequest;
    private List<Requests> _requests;
    private List<Svec> _svec;
    private ProtocolVersion _version;
    Map<Class<? extends Augmentation<PcreqMessage>>, Augmentation<PcreqMessage>> augmentation = Map.of();

    public PcreqMessageBuilder() {
    }

    public PcreqMessageBuilder(MessageHeader arg) {
        this._version = arg.getVersion();
    }

    public PcreqMessageBuilder(PcreqMessage base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PcreqMessage>>, Augmentation<PcreqMessage>>(aug);
        }
        this._monitoringRequest = base.getMonitoringRequest();
        this._requests = base.getRequests();
        this._svec = base.getSvec();
        this._version = base.getVersion();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MessageHeader) {
            MessageHeader castArg = (MessageHeader)arg;
            this._version = castArg.getVersion();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[MessageHeader]");
    }

    public static @NonNull PcreqMessage empty() {
        return LazyEmpty.INSTANCE;
    }

    public MonitoringRequest getMonitoringRequest() {
        return this._monitoringRequest;
    }

    public List<Requests> getRequests() {
        return this._requests;
    }

    public List<Svec> getSvec() {
        return this._svec;
    }

    public ProtocolVersion getVersion() {
        return this._version;
    }

    public <E$$ extends Augmentation<PcreqMessage>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public PcreqMessageBuilder setMonitoringRequest(MonitoringRequest value) {
        this._monitoringRequest = value;
        return this;
    }

    public PcreqMessageBuilder setRequests(List<Requests> values) {
        this._requests = values;
        return this;
    }

    public PcreqMessageBuilder setSvec(List<Svec> values) {
        this._svec = values;
        return this;
    }

    public PcreqMessageBuilder setVersion(ProtocolVersion value) {
        this._version = value;
        return this;
    }

    public PcreqMessageBuilder addAugmentation(Augmentation<PcreqMessage> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PcreqMessage>>, Augmentation<PcreqMessage>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public PcreqMessageBuilder removeAugmentation(Class<? extends Augmentation<PcreqMessage>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull PcreqMessage build() {
        return new PcreqMessageImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull PcreqMessage INSTANCE = new PcreqMessageBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class PcreqMessageImpl
    extends AbstractAugmentable<PcreqMessage>
    implements PcreqMessage {
        private final MonitoringRequest _monitoringRequest;
        private final List<Requests> _requests;
        private final List<Svec> _svec;
        private final ProtocolVersion _version;
        private int hash = 0;
        private volatile boolean hashValid = false;

        PcreqMessageImpl(PcreqMessageBuilder base) {
            super(base.augmentation);
            this._monitoringRequest = base.getMonitoringRequest();
            this._requests = CodeHelpers.emptyToNull(base.getRequests());
            this._svec = CodeHelpers.emptyToNull(base.getSvec());
            this._version = base.getVersion();
        }

        @Override
        public MonitoringRequest getMonitoringRequest() {
            return this._monitoringRequest;
        }

        @Override
        public List<Requests> getRequests() {
            return this._requests;
        }

        @Override
        public List<Svec> getSvec() {
            return this._svec;
        }

        @Override
        public ProtocolVersion getVersion() {
            return this._version;
        }

        @Override
        public MonitoringRequest nonnullMonitoringRequest() {
            return Objects.requireNonNullElse(this.getMonitoringRequest(), MonitoringRequestBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = PcreqMessage.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return PcreqMessage.bindingEquals(this, obj);
        }

        public String toString() {
            return PcreqMessage.bindingToString(this);
        }
    }
}

