/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.SegmentComputation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.P2mp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.P2mpBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.P2p;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.P2pBuilder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class SegmentComputationBuilder {
    private P2mp _p2mp;
    private P2p _p2p;
    Map<Class<? extends Augmentation<SegmentComputation>>, Augmentation<SegmentComputation>> augmentation = Map.of();

    public SegmentComputationBuilder() {
    }

    public SegmentComputationBuilder(SegmentComputation base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SegmentComputation>>, Augmentation<SegmentComputation>>(aug);
        }
        this._p2mp = base.getP2mp();
        this._p2p = base.getP2p();
    }

    public static @NonNull SegmentComputation empty() {
        return LazyEmpty.INSTANCE;
    }

    public P2mp getP2mp() {
        return this._p2mp;
    }

    public P2p getP2p() {
        return this._p2p;
    }

    public <E$$ extends Augmentation<SegmentComputation>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public SegmentComputationBuilder setP2mp(P2mp value) {
        this._p2mp = value;
        return this;
    }

    public SegmentComputationBuilder setP2p(P2p value) {
        this._p2p = value;
        return this;
    }

    public SegmentComputationBuilder addAugmentation(Augmentation<SegmentComputation> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SegmentComputation>>, Augmentation<SegmentComputation>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public SegmentComputationBuilder removeAugmentation(Class<? extends Augmentation<SegmentComputation>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull SegmentComputation build() {
        return new SegmentComputationImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull SegmentComputation INSTANCE = new SegmentComputationBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class SegmentComputationImpl
    extends AbstractAugmentable<SegmentComputation>
    implements SegmentComputation {
        private final P2mp _p2mp;
        private final P2p _p2p;
        private int hash = 0;
        private volatile boolean hashValid = false;

        SegmentComputationImpl(SegmentComputationBuilder base) {
            super(base.augmentation);
            this._p2mp = base.getP2mp();
            this._p2p = base.getP2p();
        }

        @Override
        public P2mp getP2mp() {
            return this._p2mp;
        }

        @Override
        public P2p getP2p() {
            return this._p2p;
        }

        @Override
        public P2mp nonnullP2mp() {
            return Objects.requireNonNullElse(this.getP2mp(), P2mpBuilder.empty());
        }

        @Override
        public P2p nonnullP2p() {
            return Objects.requireNonNullElse(this.getP2p(), P2pBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = SegmentComputation.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return SegmentComputation.bindingEquals(this, obj);
        }

        public String toString() {
            return SegmentComputation.bindingToString(this);
        }
    }
}

