/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.rp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.OrderTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.PathSetupTypeTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.VendorInformationTlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.order.tlv.Order;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.order.tlv.OrderBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.path.setup.type.tlv.PathSetupType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.path.setup.type.tlv.PathSetupTypeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.rp.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.tlvs.VendorInformationTlv;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TlvsBuilder {
    private Order _order;
    private PathSetupType _pathSetupType;
    private List<VendorInformationTlv> _vendorInformationTlv;
    Map<Class<? extends Augmentation<Tlvs>>, Augmentation<Tlvs>> augmentation = Map.of();

    public TlvsBuilder() {
    }

    public TlvsBuilder(OrderTlv arg) {
        this._order = arg.getOrder();
    }

    public TlvsBuilder(VendorInformationTlvs arg) {
        this._vendorInformationTlv = arg.getVendorInformationTlv();
    }

    public TlvsBuilder(PathSetupTypeTlv arg) {
        this._pathSetupType = arg.getPathSetupType();
    }

    public TlvsBuilder(Tlvs base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Tlvs>>, Augmentation<Tlvs>>(aug);
        }
        this._order = base.getOrder();
        this._pathSetupType = base.getPathSetupType();
        this._vendorInformationTlv = base.getVendorInformationTlv();
    }

    public void fieldsFrom(DataObject arg) {
        Object castArg;
        boolean isValidArg = false;
        if (arg instanceof VendorInformationTlvs) {
            castArg = (VendorInformationTlvs)arg;
            this._vendorInformationTlv = castArg.getVendorInformationTlv();
            isValidArg = true;
        }
        if (arg instanceof PathSetupTypeTlv) {
            castArg = (PathSetupTypeTlv)arg;
            this._pathSetupType = castArg.getPathSetupType();
            isValidArg = true;
        }
        if (arg instanceof OrderTlv) {
            castArg = (OrderTlv)arg;
            this._order = castArg.getOrder();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[VendorInformationTlvs, PathSetupTypeTlv, OrderTlv]");
    }

    public static @NonNull Tlvs empty() {
        return LazyEmpty.INSTANCE;
    }

    public Order getOrder() {
        return this._order;
    }

    public PathSetupType getPathSetupType() {
        return this._pathSetupType;
    }

    public List<VendorInformationTlv> getVendorInformationTlv() {
        return this._vendorInformationTlv;
    }

    public <E$$ extends Augmentation<Tlvs>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public TlvsBuilder setOrder(Order value) {
        this._order = value;
        return this;
    }

    public TlvsBuilder setPathSetupType(PathSetupType value) {
        this._pathSetupType = value;
        return this;
    }

    public TlvsBuilder setVendorInformationTlv(List<VendorInformationTlv> values) {
        this._vendorInformationTlv = values;
        return this;
    }

    public TlvsBuilder addAugmentation(Augmentation<Tlvs> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Tlvs>>, Augmentation<Tlvs>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public TlvsBuilder removeAugmentation(Class<? extends Augmentation<Tlvs>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Tlvs build() {
        return new TlvsImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull Tlvs INSTANCE = new TlvsBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class TlvsImpl
    extends AbstractAugmentable<Tlvs>
    implements Tlvs {
        private final Order _order;
        private final PathSetupType _pathSetupType;
        private final List<VendorInformationTlv> _vendorInformationTlv;
        private int hash = 0;
        private volatile boolean hashValid = false;

        TlvsImpl(TlvsBuilder base) {
            super(base.augmentation);
            this._order = base.getOrder();
            this._pathSetupType = base.getPathSetupType();
            this._vendorInformationTlv = CodeHelpers.emptyToNull(base.getVendorInformationTlv());
        }

        @Override
        public Order getOrder() {
            return this._order;
        }

        @Override
        public PathSetupType getPathSetupType() {
            return this._pathSetupType;
        }

        @Override
        public List<VendorInformationTlv> getVendorInformationTlv() {
            return this._vendorInformationTlv;
        }

        @Override
        public Order nonnullOrder() {
            return Objects.requireNonNullElse(this.getOrder(), OrderBuilder.empty());
        }

        @Override
        public PathSetupType nonnullPathSetupType() {
            return Objects.requireNonNullElse(this.getPathSetupType(), PathSetupTypeBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Tlvs.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Tlvs.bindingEquals(this, obj);
        }

        public String toString() {
            return Tlvs.bindingToString(this);
        }
    }
}

