/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev230112.PcepSessionTimers;
import org.opendaylight.yangtools.yang.common.Uint8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record PCEPTimerProposal(@NonNull Uint8 keepAlive, @NonNull Uint8 deadTimer) {
    private static final Logger LOG = LoggerFactory.getLogger(PCEPTimerProposal.class);
    private static final int KA_TO_DEADTIMER_RATIO = 4;

    public PCEPTimerProposal(@NonNull Uint8 keepAlive, @NonNull Uint8 deadTimer) {
        Objects.requireNonNull(keepAlive);
        if (!Uint8.ZERO.equals(keepAlive)) {
            Objects.requireNonNull(deadTimer);
            if (!Uint8.ZERO.equals(deadTimer) && deadTimer.toJava() / keepAlive.toJava() != 4) {
                LOG.warn("dead-timer-value ({}) should be {} times greater than keep-alive-timer-value ({}}", new Object[]{deadTimer, 4, keepAlive});
            }
        } else {
            deadTimer = Uint8.ZERO;
        }
    }

    public PCEPTimerProposal(PcepSessionTimers timers) {
        this(timers.requireKeepAliveTimerValue(), timers.requireDeadTimerValue());
    }
}

