/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev230112.pcep.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev230112.PcepSessionErrorPolicy;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev230112.PcepSessionTimers;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev230112.pcep.config.SessionConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev230112.pcep.config.session.config.Tls;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint8;

public class SessionConfigBuilder {
    private Uint8 _deadTimerValue;
    private Uint8 _keepAliveTimerValue;
    private IpAddressNoZone _listenAddress;
    private PortNumber _listenPort;
    private Uint16 _maxUnknownMessages;
    private Short _rpcTimeout;
    private Tls _tls;
    Map<Class<? extends Augmentation<SessionConfig>>, Augmentation<SessionConfig>> augmentation = Map.of();

    public SessionConfigBuilder() {
    }

    public SessionConfigBuilder(PcepSessionErrorPolicy arg) {
        this._maxUnknownMessages = arg.getMaxUnknownMessages();
    }

    public SessionConfigBuilder(PcepSessionTimers arg) {
        this._deadTimerValue = arg.getDeadTimerValue();
        this._keepAliveTimerValue = arg.getKeepAliveTimerValue();
    }

    public SessionConfigBuilder(SessionConfig base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SessionConfig>>, Augmentation<SessionConfig>>(aug);
        }
        this._deadTimerValue = base.getDeadTimerValue();
        this._keepAliveTimerValue = base.getKeepAliveTimerValue();
        this._listenAddress = base.getListenAddress();
        this._listenPort = base.getListenPort();
        this._maxUnknownMessages = base.getMaxUnknownMessages();
        this._rpcTimeout = base.getRpcTimeout();
        this._tls = base.getTls();
    }

    public void fieldsFrom(DataObject arg) {
        Object castArg;
        boolean isValidArg = false;
        if (arg instanceof PcepSessionErrorPolicy) {
            castArg = (PcepSessionErrorPolicy)arg;
            this._maxUnknownMessages = castArg.getMaxUnknownMessages();
            isValidArg = true;
        }
        if (arg instanceof PcepSessionTimers) {
            castArg = (PcepSessionTimers)arg;
            this._deadTimerValue = castArg.getDeadTimerValue();
            this._keepAliveTimerValue = castArg.getKeepAliveTimerValue();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[PcepSessionErrorPolicy, PcepSessionTimers]");
    }

    public static @NonNull SessionConfig empty() {
        return LazyEmpty.INSTANCE;
    }

    public Uint8 getDeadTimerValue() {
        return this._deadTimerValue;
    }

    public Uint8 getKeepAliveTimerValue() {
        return this._keepAliveTimerValue;
    }

    public IpAddressNoZone getListenAddress() {
        return this._listenAddress;
    }

    public PortNumber getListenPort() {
        return this._listenPort;
    }

    public Uint16 getMaxUnknownMessages() {
        return this._maxUnknownMessages;
    }

    public Short getRpcTimeout() {
        return this._rpcTimeout;
    }

    public Tls getTls() {
        return this._tls;
    }

    public <E$$ extends Augmentation<SessionConfig>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public SessionConfigBuilder setDeadTimerValue(Uint8 value) {
        this._deadTimerValue = value;
        return this;
    }

    public SessionConfigBuilder setKeepAliveTimerValue(Uint8 value) {
        this._keepAliveTimerValue = value;
        return this;
    }

    public SessionConfigBuilder setListenAddress(IpAddressNoZone value) {
        this._listenAddress = value;
        return this;
    }

    public SessionConfigBuilder setListenPort(PortNumber value) {
        this._listenPort = value;
        return this;
    }

    private static void checkMaxUnknownMessagesRange(int value) {
        if (value >= 1) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[1..65535]]", (int)value);
    }

    public SessionConfigBuilder setMaxUnknownMessages(Uint16 value) {
        if (value != null) {
            SessionConfigBuilder.checkMaxUnknownMessagesRange(value.intValue());
        }
        this._maxUnknownMessages = value;
        return this;
    }

    public SessionConfigBuilder setRpcTimeout(Short value) {
        this._rpcTimeout = value;
        return this;
    }

    public SessionConfigBuilder setTls(Tls value) {
        this._tls = value;
        return this;
    }

    public SessionConfigBuilder addAugmentation(Augmentation<SessionConfig> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SessionConfig>>, Augmentation<SessionConfig>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public SessionConfigBuilder removeAugmentation(Class<? extends Augmentation<SessionConfig>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull SessionConfig build() {
        return new SessionConfigImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull SessionConfig INSTANCE = new SessionConfigBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class SessionConfigImpl
    extends AbstractAugmentable<SessionConfig>
    implements SessionConfig {
        private final Uint8 _deadTimerValue;
        private final Uint8 _keepAliveTimerValue;
        private final IpAddressNoZone _listenAddress;
        private final PortNumber _listenPort;
        private final Uint16 _maxUnknownMessages;
        private final Short _rpcTimeout;
        private final Tls _tls;
        private int hash = 0;
        private volatile boolean hashValid = false;

        SessionConfigImpl(SessionConfigBuilder base) {
            super(base.augmentation);
            this._deadTimerValue = base.getDeadTimerValue();
            this._keepAliveTimerValue = base.getKeepAliveTimerValue();
            this._listenAddress = base.getListenAddress();
            this._listenPort = base.getListenPort();
            this._maxUnknownMessages = base.getMaxUnknownMessages();
            this._rpcTimeout = base.getRpcTimeout();
            this._tls = base.getTls();
        }

        @Override
        public Uint8 getDeadTimerValue() {
            return this._deadTimerValue;
        }

        @Override
        public Uint8 getKeepAliveTimerValue() {
            return this._keepAliveTimerValue;
        }

        @Override
        public IpAddressNoZone getListenAddress() {
            return this._listenAddress;
        }

        @Override
        public PortNumber getListenPort() {
            return this._listenPort;
        }

        @Override
        public Uint16 getMaxUnknownMessages() {
            return this._maxUnknownMessages;
        }

        @Override
        public Short getRpcTimeout() {
            return this._rpcTimeout;
        }

        @Override
        public Tls getTls() {
            return this._tls;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = SessionConfig.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return SessionConfig.bindingEquals(this, obj);
        }

        public String toString() {
            return SessionConfig.bindingToString(this);
        }
    }
}

