/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;
import org.opendaylight.yangtools.yang.common.Uint32;

public class RequestId
implements ScalarTypeObject<Uint32>,
Serializable {
    private static final long serialVersionUID = 3068263630509172403L;
    private final Uint32 _value;

    private static void check_valueRange(long value) {
        if (value >= 1L) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[1..4294967295]]", (long)value);
    }

    @ConstructorParameters(value={"value"})
    public RequestId(Uint32 _value) {
        if (_value != null) {
            RequestId.check_valueRange(_value.longValue());
        }
        CodeHelpers.requireValue((Object)_value);
        this._value = _value;
    }

    public RequestId(RequestId source) {
        this._value = source._value;
    }

    public static RequestId getDefaultInstance(String defaultValue) {
        return new RequestId(Uint32.valueOf((String)defaultValue));
    }

    public Uint32 getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof RequestId)) return false;
        RequestId other = (RequestId)obj;
        if (!Objects.equals(this._value, other._value)) return false;
        return true;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(RequestId.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"value", (Object)this._value);
        return helper.toString();
    }
}

