/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.p2mp.ipv6._case;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.EndpointsIpv6Source;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Ipv6Destinations;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.P2mpLeaves;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.P2mpLeavesLeaf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.p2mp.ipv6._case.P2mpIpv6;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class P2mpIpv6Builder {
    private Set<Ipv6AddressNoZone> _destinationIpv6Address;
    private P2mpLeaves _p2mpLeaves;
    private Ipv6AddressNoZone _sourceIpv6Address;
    Map<Class<? extends Augmentation<P2mpIpv6>>, Augmentation<P2mpIpv6>> augmentation = Map.of();

    public P2mpIpv6Builder() {
    }

    public P2mpIpv6Builder(P2mpLeavesLeaf arg) {
        this._p2mpLeaves = arg.getP2mpLeaves();
    }

    public P2mpIpv6Builder(EndpointsIpv6Source arg) {
        this._sourceIpv6Address = arg.getSourceIpv6Address();
    }

    public P2mpIpv6Builder(Ipv6Destinations arg) {
        this._destinationIpv6Address = arg.getDestinationIpv6Address();
    }

    public P2mpIpv6Builder(P2mpIpv6 base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<P2mpIpv6>>, Augmentation<P2mpIpv6>>(aug);
        }
        this._destinationIpv6Address = base.getDestinationIpv6Address();
        this._p2mpLeaves = base.getP2mpLeaves();
        this._sourceIpv6Address = base.getSourceIpv6Address();
    }

    public void fieldsFrom(DataObject arg) {
        Object castArg;
        boolean isValidArg = false;
        if (arg instanceof EndpointsIpv6Source) {
            castArg = (EndpointsIpv6Source)arg;
            this._sourceIpv6Address = castArg.getSourceIpv6Address();
            isValidArg = true;
        }
        if (arg instanceof P2mpLeavesLeaf) {
            castArg = (P2mpLeavesLeaf)arg;
            this._p2mpLeaves = castArg.getP2mpLeaves();
            isValidArg = true;
        }
        if (arg instanceof Ipv6Destinations) {
            castArg = (Ipv6Destinations)arg;
            this._destinationIpv6Address = castArg.getDestinationIpv6Address();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[EndpointsIpv6Source, P2mpLeavesLeaf, Ipv6Destinations]");
    }

    public static @NonNull P2mpIpv6 empty() {
        return LazyEmpty.INSTANCE;
    }

    public Set<Ipv6AddressNoZone> getDestinationIpv6Address() {
        return this._destinationIpv6Address;
    }

    public P2mpLeaves getP2mpLeaves() {
        return this._p2mpLeaves;
    }

    public Ipv6AddressNoZone getSourceIpv6Address() {
        return this._sourceIpv6Address;
    }

    public <E$$ extends Augmentation<P2mpIpv6>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public P2mpIpv6Builder setDestinationIpv6Address(Set<Ipv6AddressNoZone> values) {
        this._destinationIpv6Address = values;
        return this;
    }

    public P2mpIpv6Builder setP2mpLeaves(P2mpLeaves value) {
        this._p2mpLeaves = value;
        return this;
    }

    public P2mpIpv6Builder setSourceIpv6Address(Ipv6AddressNoZone value) {
        this._sourceIpv6Address = value;
        return this;
    }

    public P2mpIpv6Builder addAugmentation(Augmentation<P2mpIpv6> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<P2mpIpv6>>, Augmentation<P2mpIpv6>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public P2mpIpv6Builder removeAugmentation(Class<? extends Augmentation<P2mpIpv6>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull P2mpIpv6 build() {
        return new P2mpIpv6Impl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull P2mpIpv6 INSTANCE = new P2mpIpv6Builder().build();

        private LazyEmpty() {
        }
    }

    private static final class P2mpIpv6Impl
    extends AbstractAugmentable<P2mpIpv6>
    implements P2mpIpv6 {
        private final Set<Ipv6AddressNoZone> _destinationIpv6Address;
        private final P2mpLeaves _p2mpLeaves;
        private final Ipv6AddressNoZone _sourceIpv6Address;
        private int hash = 0;
        private volatile boolean hashValid = false;

        P2mpIpv6Impl(P2mpIpv6Builder base) {
            super(base.augmentation);
            this._destinationIpv6Address = base.getDestinationIpv6Address();
            this._p2mpLeaves = base.getP2mpLeaves();
            this._sourceIpv6Address = base.getSourceIpv6Address();
        }

        @Override
        public Set<Ipv6AddressNoZone> getDestinationIpv6Address() {
            return this._destinationIpv6Address;
        }

        @Override
        public P2mpLeaves getP2mpLeaves() {
            return this._p2mpLeaves;
        }

        @Override
        public Ipv6AddressNoZone getSourceIpv6Address() {
            return this._sourceIpv6Address;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = P2mpIpv6.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return P2mpIpv6.bindingEquals(this, obj);
        }

        public String toString() {
            return P2mpIpv6.bindingToString(this);
        }
    }
}

