/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.load.balancing.object;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.load.balancing.object.LoadBalancing;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

public class LoadBalancingBuilder {
    private Boolean _ignore;
    private Uint8 _maxLsp;
    private Bandwidth _minBandwidth;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<LoadBalancing>>, Augmentation<LoadBalancing>> augmentation = Map.of();

    public LoadBalancingBuilder() {
    }

    public LoadBalancingBuilder(Object arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public LoadBalancingBuilder(ObjectHeader arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public LoadBalancingBuilder(LoadBalancing base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LoadBalancing>>, Augmentation<LoadBalancing>>(aug);
        }
        this._ignore = base.getIgnore();
        this._maxLsp = base.getMaxLsp();
        this._minBandwidth = base.getMinBandwidth();
        this._processingRule = base.getProcessingRule();
    }

    public void fieldsFrom(DataObject arg) {
        ObjectHeader castArg;
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            castArg = (ObjectHeader)arg;
            this._processingRule = castArg.getProcessingRule();
            this._ignore = castArg.getIgnore();
            isValidArg = true;
        }
        if (arg instanceof Object) {
            castArg = (Object)arg;
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (java.lang.Object)arg, (String)"[ObjectHeader, Object]");
    }

    public static @NonNull LoadBalancing empty() {
        return LazyEmpty.INSTANCE;
    }

    public Boolean getIgnore() {
        return this._ignore;
    }

    public Uint8 getMaxLsp() {
        return this._maxLsp;
    }

    public Bandwidth getMinBandwidth() {
        return this._minBandwidth;
    }

    public Boolean getProcessingRule() {
        return this._processingRule;
    }

    public <E$$ extends Augmentation<LoadBalancing>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public LoadBalancingBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public LoadBalancingBuilder setMaxLsp(Uint8 value) {
        this._maxLsp = value;
        return this;
    }

    public LoadBalancingBuilder setMinBandwidth(Bandwidth value) {
        this._minBandwidth = value;
        return this;
    }

    public LoadBalancingBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public LoadBalancingBuilder addAugmentation(Augmentation<LoadBalancing> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LoadBalancing>>, Augmentation<LoadBalancing>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public LoadBalancingBuilder removeAugmentation(Class<? extends Augmentation<LoadBalancing>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull LoadBalancing build() {
        return new LoadBalancingImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull LoadBalancing INSTANCE = new LoadBalancingBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class LoadBalancingImpl
    extends AbstractAugmentable<LoadBalancing>
    implements LoadBalancing {
        private final Boolean _ignore;
        private final Uint8 _maxLsp;
        private final Bandwidth _minBandwidth;
        private final Boolean _processingRule;
        private int hash = 0;
        private volatile boolean hashValid = false;

        LoadBalancingImpl(LoadBalancingBuilder base) {
            super(base.augmentation);
            this._ignore = base.getIgnore();
            this._maxLsp = base.getMaxLsp();
            this._minBandwidth = base.getMinBandwidth();
            this._processingRule = base.getProcessingRule();
        }

        @Override
        public Boolean getIgnore() {
            return this._ignore;
        }

        @Override
        public Uint8 getMaxLsp() {
            return this._maxLsp;
        }

        @Override
        public Bandwidth getMinBandwidth() {
            return this._minBandwidth;
        }

        @Override
        public Boolean getProcessingRule() {
            return this._processingRule;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = LoadBalancing.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(java.lang.Object obj) {
            return LoadBalancing.bindingEquals(this, obj);
        }

        public String toString() {
            return LoadBalancing.bindingToString(this);
        }
    }
}

