/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.MonitoringObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object.monitoring.Tlvs;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.BitsTypeObject;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

public interface Monitoring
extends ChildOf<MonitoringObject>,
Augmentable<Monitoring>,
Object {
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("monitoring");

    default public Class<Monitoring> implementedInterface() {
        return Monitoring.class;
    }

    public static int bindingHashCode(@NonNull Monitoring obj) {
        int result = 1;
        int prime = 31;
        result = 31 * result + Objects.hashCode(obj.getFlags());
        result = 31 * result + Objects.hashCode(obj.getIgnore());
        result = 31 * result + Objects.hashCode(obj.getMonitoringId());
        result = 31 * result + Objects.hashCode(obj.getProcessingRule());
        result = 31 * result + Objects.hashCode(obj.getTlvs());
        for (Augmentation augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }

    public static boolean bindingEquals(@NonNull Monitoring thisObj, java.lang.Object obj) {
        if (thisObj == obj) {
            return true;
        }
        Monitoring other = (Monitoring)CodeHelpers.checkCast(Monitoring.class, (java.lang.Object)obj);
        return other != null && Objects.equals(thisObj.getIgnore(), other.getIgnore()) && Objects.equals(thisObj.getMonitoringId(), other.getMonitoringId()) && Objects.equals(thisObj.getProcessingRule(), other.getProcessingRule()) && Objects.equals(thisObj.getFlags(), other.getFlags()) && Objects.equals(thisObj.getTlvs(), other.getTlvs()) && thisObj.augmentations().equals(other.augmentations());
    }

    public static String bindingToString(@NonNull Monitoring obj) {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Monitoring");
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"flags", (java.lang.Object)obj.getFlags());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"ignore", (java.lang.Object)obj.getIgnore());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"monitoringId", (java.lang.Object)obj.getMonitoringId());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"processingRule", (java.lang.Object)obj.getProcessingRule());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"tlvs", (java.lang.Object)obj.getTlvs());
        CodeHelpers.appendAugmentations((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Augmentable)obj);
        return helper.toString();
    }

    public Flags getFlags();

    default public @NonNull Flags requireFlags() {
        return (Flags)CodeHelpers.require((java.lang.Object)this.getFlags(), (String)"flags");
    }

    public Uint32 getMonitoringId();

    default public @NonNull Uint32 requireMonitoringId() {
        return (Uint32)CodeHelpers.require((java.lang.Object)this.getMonitoringId(), (String)"monitoringid");
    }

    public Tlvs getTlvs();

    public @NonNull Tlvs nonnullTlvs();

    public static final class Flags
    implements BitsTypeObject,
    Serializable {
        private static final long serialVersionUID = -3787499348650453366L;
        protected static final ImmutableSet<String> VALID_NAMES = ImmutableSet.of((java.lang.Object)"incomplete", (java.lang.Object)"overload", (java.lang.Object)"processing-time", (java.lang.Object)"general", (java.lang.Object)"liveness");
        private final boolean _incomplete;
        private final boolean _overload;
        private final boolean _processingTime;
        private final boolean _general;
        private final boolean _liveness;

        public Flags(boolean _general, boolean _incomplete, boolean _liveness, boolean _overload, boolean _processingTime) {
            this._incomplete = _incomplete;
            this._overload = _overload;
            this._processingTime = _processingTime;
            this._general = _general;
            this._liveness = _liveness;
        }

        public Flags(Flags source) {
            this._incomplete = source._incomplete;
            this._overload = source._overload;
            this._processingTime = source._processingTime;
            this._general = source._general;
            this._liveness = source._liveness;
        }

        public boolean getIncomplete() {
            return this._incomplete;
        }

        public boolean getOverload() {
            return this._overload;
        }

        public boolean getProcessingTime() {
            return this._processingTime;
        }

        public boolean getGeneral() {
            return this._general;
        }

        public boolean getLiveness() {
            return this._liveness;
        }

        public ImmutableSet<String> validNames() {
            return VALID_NAMES;
        }

        public boolean[] values() {
            return new boolean[]{this.getIncomplete(), this.getOverload(), this.getProcessingTime(), this.getGeneral(), this.getLiveness()};
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Boolean.hashCode(this._incomplete);
            result = 31 * result + Boolean.hashCode(this._overload);
            result = 31 * result + Boolean.hashCode(this._processingTime);
            result = 31 * result + Boolean.hashCode(this._general);
            result = 31 * result + Boolean.hashCode(this._liveness);
            return result;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean equals(java.lang.Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof Flags)) return false;
            Flags other = (Flags)obj;
            if (this._incomplete != other._incomplete) return false;
            if (this._overload != other._overload) return false;
            if (this._processingTime != other._processingTime) return false;
            if (this._general != other._general) return false;
            if (this._liveness != other._liveness) return false;
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(Flags.class);
            CodeHelpers.appendBit((MoreObjects.ToStringHelper)helper, (String)"incomplete", (boolean)this._incomplete);
            CodeHelpers.appendBit((MoreObjects.ToStringHelper)helper, (String)"overload", (boolean)this._overload);
            CodeHelpers.appendBit((MoreObjects.ToStringHelper)helper, (String)"processingTime", (boolean)this._processingTime);
            CodeHelpers.appendBit((MoreObjects.ToStringHelper)helper, (String)"general", (boolean)this._general);
            CodeHelpers.appendBit((MoreObjects.ToStringHelper)helper, (String)"liveness", (boolean)this._liveness);
            return helper.toString();
        }
    }
}

