/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object.Monitoring;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object.monitoring.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object.monitoring.TlvsBuilder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

public class MonitoringBuilder {
    private Monitoring.Flags _flags;
    private Boolean _ignore;
    private Uint32 _monitoringId;
    private Boolean _processingRule;
    private Tlvs _tlvs;
    Map<Class<? extends Augmentation<Monitoring>>, Augmentation<Monitoring>> augmentation = Map.of();

    public MonitoringBuilder() {
    }

    public MonitoringBuilder(Object arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public MonitoringBuilder(ObjectHeader arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public MonitoringBuilder(Monitoring base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Monitoring>>, Augmentation<Monitoring>>(aug);
        }
        this._flags = base.getFlags();
        this._ignore = base.getIgnore();
        this._monitoringId = base.getMonitoringId();
        this._processingRule = base.getProcessingRule();
        this._tlvs = base.getTlvs();
    }

    public void fieldsFrom(DataObject arg) {
        ObjectHeader castArg;
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            castArg = (ObjectHeader)arg;
            this._processingRule = castArg.getProcessingRule();
            this._ignore = castArg.getIgnore();
            isValidArg = true;
        }
        if (arg instanceof Object) {
            castArg = (Object)arg;
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (java.lang.Object)arg, (String)"[ObjectHeader, Object]");
    }

    public static @NonNull Monitoring empty() {
        return LazyEmpty.INSTANCE;
    }

    public Monitoring.Flags getFlags() {
        return this._flags;
    }

    public Boolean getIgnore() {
        return this._ignore;
    }

    public Uint32 getMonitoringId() {
        return this._monitoringId;
    }

    public Boolean getProcessingRule() {
        return this._processingRule;
    }

    public Tlvs getTlvs() {
        return this._tlvs;
    }

    public <E$$ extends Augmentation<Monitoring>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public MonitoringBuilder setFlags(Monitoring.Flags value) {
        this._flags = value;
        return this;
    }

    public MonitoringBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public MonitoringBuilder setMonitoringId(Uint32 value) {
        this._monitoringId = value;
        return this;
    }

    public MonitoringBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public MonitoringBuilder setTlvs(Tlvs value) {
        this._tlvs = value;
        return this;
    }

    public MonitoringBuilder addAugmentation(Augmentation<Monitoring> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Monitoring>>, Augmentation<Monitoring>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public MonitoringBuilder removeAugmentation(Class<? extends Augmentation<Monitoring>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Monitoring build() {
        return new MonitoringImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull Monitoring INSTANCE = new MonitoringBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class MonitoringImpl
    extends AbstractAugmentable<Monitoring>
    implements Monitoring {
        private final Monitoring.Flags _flags;
        private final Boolean _ignore;
        private final Uint32 _monitoringId;
        private final Boolean _processingRule;
        private final Tlvs _tlvs;
        private int hash = 0;
        private volatile boolean hashValid = false;

        MonitoringImpl(MonitoringBuilder base) {
            super(base.augmentation);
            this._flags = base.getFlags();
            this._ignore = base.getIgnore();
            this._monitoringId = base.getMonitoringId();
            this._processingRule = base.getProcessingRule();
            this._tlvs = base.getTlvs();
        }

        @Override
        public Monitoring.Flags getFlags() {
            return this._flags;
        }

        @Override
        public Boolean getIgnore() {
            return this._ignore;
        }

        @Override
        public Uint32 getMonitoringId() {
            return this._monitoringId;
        }

        @Override
        public Boolean getProcessingRule() {
            return this._processingRule;
        }

        @Override
        public Tlvs getTlvs() {
            return this._tlvs;
        }

        @Override
        public Tlvs nonnullTlvs() {
            return Objects.requireNonNullElse(this.getTlvs(), TlvsBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Monitoring.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(java.lang.Object obj) {
            return Monitoring.bindingEquals(this, obj);
        }

        public String toString() {
            return Monitoring.bindingToString(this);
        }
    }
}

